/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.support;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.pages.Page;
import com.midori.confluence.plugin.archiving.model.util.Labeling;
import com.midori.confluence.plugin.archiving.model.util.YymmddLabeling;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusType;
import com.midori.confluence.plugin.archiving.web.rest.model.QuickAction;
import com.midori.confluence.plugin.archiving.web.rest.model.QuickActionType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class QuickActionHelper {
    private static final boolean ENABLE_ALL_ACTIONS = false;
    public static final String USERNAME_DELIMITER = ",";
    private ContentLifecycleLabelHelper contentLifecycleLabelHelper;
    private ContentTraversalHelper contentTraversalHelper;

    public QuickActionHelper(ContentLifecycleLabelHelper contentLifecycleLabelHelper, ContentTraversalHelper contentTraversalHelper) {
        this.contentLifecycleLabelHelper = contentLifecycleLabelHelper;
        this.contentTraversalHelper = contentTraversalHelper;
    }

    public Map<String, QuickAction> getActionsForPage(Page page, ContentStatusType contentStatusType, Long ancestorId) {
        HashMap<String, QuickAction> actions = new HashMap<String, QuickAction>();
        Map<String, Labeling> labelsToLabelings = this.contentLifecycleLabelHelper.getLabelsToLabelings((AbstractLabelableEntityObject)page);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (QuickActionType actionType : QuickActionType.values()) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (actionType.equals((Object)QuickActionType.OWN)) {
                Set<String> ownersSingle = ContentLifecycleLabelHelper.getUserNamesFromPageLabels(page, "owned-single-by-");
                Set<String> ownersRecursive = ContentLifecycleLabelHelper.getUserNamesFromPageLabels(page, "owned-by-");
                if (!ownersSingle.isEmpty()) {
                    context.put("ownersSingle", ownersSingle.stream().sorted().collect(Collectors.joining(USERNAME_DELIMITER)));
                }
                if (!ownersRecursive.isEmpty()) {
                    context.put("ownersRecursive", ownersRecursive.stream().sorted().collect(Collectors.joining(USERNAME_DELIMITER)));
                }
            } else if (actionType.equals((Object)QuickActionType.EXPIRE)) {
                YymmddLabeling earliestExpireLabeling = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(labelsToLabelings, "expire-", "expire-single-");
                if (earliestExpireLabeling != null) {
                    context.put("date", dateFormat.format(earliestExpireLabeling.getDate()));
                    context.put("recursive", ContentLifecycleLabelHelper.isRecursiveLabel(earliestExpireLabeling.getLabelName()));
                }
            } else if (actionType.equals((Object)QuickActionType.ARCHIVE)) {
                String reason;
                if (this.contentLifecycleLabelHelper.hasLabelWithPattern(page, "archive")) {
                    context.put("recursive", true);
                } else if (this.contentLifecycleLabelHelper.hasLabelWithPattern(page, "archive-single")) {
                    context.put("recursive", false);
                } else {
                    YymmddLabeling earliestArchiveLabeling = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(labelsToLabelings, "archive-", "archive-single-");
                    if (earliestArchiveLabeling != null) {
                        context.put("date", dateFormat.format(earliestArchiveLabeling.getDate()));
                        context.put("recursive", ContentLifecycleLabelHelper.isRecursiveLabel(earliestArchiveLabeling.getLabelName()));
                    }
                }
                boolean isArchivingLabelFound = context.containsKey("recursive");
                if (isArchivingLabelFound && StringUtils.isNotBlank((String)(reason = this.contentTraversalHelper.getArchivingReason(page, false)))) {
                    context.put("reason", reason);
                }
            } else if (actionType.equals((Object)QuickActionType.JUMP) && ancestorId != null) {
                context.put("ancestorId", ancestorId);
            }
            actions.put(actionType.getCode(), new QuickAction(actionType, context));
        }
        return actions;
    }

    public List<String> getPrimaryActionCodesAvailableForPage(Page page, ContentStatusType contentStatusType, Long ancestorId) {
        boolean hasArchiveLabel = this.contentLifecycleLabelHelper.hasLabelWithPattern(page, ContentLifecycleLabelHelper.ALL_ARCHIVE_LABEL_PATTERNS);
        boolean hasExpireLabel = this.contentLifecycleLabelHelper.hasLabelWithPattern(page, ContentLifecycleLabelHelper.ALL_EXPIRE_LABEL_PATTERNS);
        boolean viaAncestor = ancestorId != null;
        ArrayList<String> actionCodes = new ArrayList<String>();
        if (contentStatusType == ContentStatusType.UP_TO_DATE || contentStatusType == ContentStatusType.NOT_VIEWED || contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && !viaAncestor || contentStatusType == ContentStatusType.EXPIRED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && !viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE || contentStatusType == ContentStatusType.EXCLUDED && !viaAncestor || contentStatusType == ContentStatusType.UNKNOWN_LAST_VIEW_UNAVAILABLE || contentStatusType == ContentStatusType.UNKNOWN_LAST_UPDATE_UNAVAILABLE) {
            actionCodes.add(QuickActionType.DISCUSS.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE || contentStatusType == ContentStatusType.UNKNOWN_LAST_UPDATE_UNAVAILABLE) {
            actionCodes.add(QuickActionType.UPDATE.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE) {
            actionCodes.add(QuickActionType.CONFIRM.getCode());
        }
        if (contentStatusType == ContentStatusType.UP_TO_DATE || contentStatusType == ContentStatusType.NOT_VIEWED || contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && !viaAncestor || contentStatusType == ContentStatusType.EXPIRED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && !viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE) {
            actionCodes.add(QuickActionType.OWN.getCode());
        }
        if (contentStatusType == ContentStatusType.UP_TO_DATE || contentStatusType == ContentStatusType.NOT_VIEWED || contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && !viaAncestor || hasExpireLabel) {
            actionCodes.add(QuickActionType.EXPIRE.getCode());
        }
        if (hasExpireLabel) {
            actionCodes.add(QuickActionType.UNEXPIRE.getCode());
        }
        if (contentStatusType == ContentStatusType.UP_TO_DATE || contentStatusType == ContentStatusType.NOT_VIEWED || contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && !viaAncestor || contentStatusType == ContentStatusType.EXPIRED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && !viaAncestor || hasArchiveLabel) {
            actionCodes.add(QuickActionType.ARCHIVE.getCode());
        }
        if (hasArchiveLabel) {
            actionCodes.add(QuickActionType.UNARCHIVE.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.EXCLUDED && viaAncestor) {
            actionCodes.add(QuickActionType.JUMP.getCode());
        }
        if (contentStatusType == ContentStatusType.EXCLUDED && !viaAncestor) {
            actionCodes.add(QuickActionType.INCLUDE.getCode());
        }
        return actionCodes;
    }

    public List<String> getSecondaryActionCodesAvailableForPage(Page page, ContentStatusType contentStatusType, Long ancestorId) {
        boolean viaAncestor = ancestorId != null;
        ArrayList<String> actionCodes = new ArrayList<String>();
        if (contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.EXCLUDED && viaAncestor) {
            actionCodes.add(QuickActionType.DISCUSS.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && viaAncestor) {
            actionCodes.add(QuickActionType.OWN.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.EXPIRED_BY_AGE) {
            actionCodes.add(QuickActionType.EXPIRE.getCode());
        }
        if (contentStatusType == ContentStatusType.EXPIRED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_LABEL && viaAncestor || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_AGE || contentStatusType == ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE) {
            actionCodes.add(QuickActionType.ARCHIVE.getCode());
        }
        if (contentStatusType != ContentStatusType.EXCLUDED) {
            actionCodes.add(QuickActionType.EXCLUDE.getCode());
        }
        return actionCodes;
    }
}

