/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy;

import com.midori.confluence.plugin.archiving.model.ContentArchivingStats;
import com.midori.confluence.plugin.archiving.model.base.DefaultSpaceAndPageCountingStats;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataReducer;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPageArchiving;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ContentArchivingExecutionResult {
    private Map<LightSpace, LightSpace> freshSpacesToArchiveSpaces = new LinkedHashMap<LightSpace, LightSpace>();
    private Map<LightSpace, LightSpace> archiveSpacesToFreshSpaces = new LinkedHashMap<LightSpace, LightSpace>();
    private Map<LightSpace, Map<LightPage, LightPageArchiving>> freshSpacesToArchivePages = new LinkedHashMap<LightSpace, Map<LightPage, LightPageArchiving>>();
    private Map<LightSpace, Map<LightPage, LightPageArchiving>> freshSpacesToSkippedPages = new LinkedHashMap<LightSpace, Map<LightPage, LightPageArchiving>>();
    private Map<LightPage, LightPage> archivePagesToFreshPages = new LinkedHashMap<LightPage, LightPage>();
    private ContentArchivingStats aggregatedContentArchivingStats = ContentArchivingStats.empty();

    public void addExecutionContext(ContentArchivingExecutionContext context) {
        LightSpace lightSpace = LightSpace.fromSpace(context.getFreshSpace());
        this.freshSpacesToArchiveSpaces.put(lightSpace, context.getArchiveSpace() != null ? LightSpace.fromSpace(context.getArchiveSpace()) : null);
        this.archiveSpacesToFreshSpaces.put(context.getArchiveSpace() != null ? LightSpace.fromSpace(context.getArchiveSpace()) : lightSpace, lightSpace);
        Map<LightPage, LightPageArchiving> archivePagesResulted = DataReducer.lightenPageKeyedPageArchivingMap(context.getArchivePagesResulted());
        this.freshSpacesToArchivePages.put(lightSpace, archivePagesResulted);
        this.freshSpacesToSkippedPages.put(lightSpace, DataReducer.lightenPageKeyedPageArchivingMap(context.getFreshPagesSkipped()));
        for (Map.Entry<LightPage, LightPageArchiving> entry : archivePagesResulted.entrySet()) {
            this.archivePagesToFreshPages.put(entry.getKey(), entry.getValue().getFreshPage());
        }
        this.aggregatedContentArchivingStats.merge(context.toContentArchivingStats());
    }

    public Set<LightSpace> getFreshSpaces() {
        return this.freshSpacesToArchiveSpaces.keySet();
    }

    public Set<LightSpace> getArchiveSpaces() {
        return this.archiveSpacesToFreshSpaces.keySet();
    }

    public Map<LightSpace, LightSpace> getFreshSpacesToArchiveSpaces() {
        return this.freshSpacesToArchiveSpaces;
    }

    public Map<LightSpace, LightSpace> getArchiveSpacesToFreshSpaces() {
        return this.archiveSpacesToFreshSpaces;
    }

    public Map<LightPage, LightPage> getArchivePagesToFreshPages() {
        return this.archivePagesToFreshPages;
    }

    public Map<LightSpace, Map<LightPage, LightPageArchiving>> getArchivePagesByFreshSpace() {
        return this.freshSpacesToArchivePages;
    }

    public Map<LightSpace, Map<LightPage, LightPageArchiving>> getSkippedPagesByFreshSpace() {
        return this.freshSpacesToSkippedPages;
    }

    public SpaceAndPageCountingStats getArchivePageStatsByArchiveSpace() {
        DefaultSpaceAndPageCountingStats stats = new DefaultSpaceAndPageCountingStats();
        for (LightSpace archiveSpace : this.archiveSpacesToFreshSpaces.keySet()) {
            LightSpace freshSpace = this.archiveSpacesToFreshSpaces.get(archiveSpace);
            stats.addPagesForSpace(archiveSpace.getKey(), this.freshSpacesToArchivePages.get(freshSpace).size());
        }
        return stats;
    }

    public SpaceAndPageCountingStats getPageSkippingStatsByFreshSpace() {
        DefaultSpaceAndPageCountingStats stats = new DefaultSpaceAndPageCountingStats();
        for (Map.Entry<LightSpace, Map<LightPage, LightPageArchiving>> entry : this.freshSpacesToSkippedPages.entrySet()) {
            stats.addPagesForSpace(entry.getKey().getKey(), entry.getValue().size());
        }
        return stats;
    }

    public ContentArchivingStats getAggregatedContentArchivingStats() {
        return this.aggregatedContentArchivingStats;
    }
}

