/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.midori.confluence.plugin.archiving.model.ao.NotificationEmailTemplateAo;
import com.midori.confluence.plugin.archiving.model.type.NotificationEmailTemplateType;
import java.util.Date;

public class NotificationEmailTemplate {
    private final NotificationEmailTemplateType type;
    private final String subject;
    private final String content;
    private final boolean defaultContent;
    private final Date updated;

    public static NotificationEmailTemplate fromAo(NotificationEmailTemplateType notificationEmailTemplateType, NotificationEmailTemplateAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("NotificationEmailTemplateAo provided must not be null");
        }
        return new NotificationEmailTemplate(notificationEmailTemplateType, ao.getSubject(), ao.getContent(), false, ao.getUpdated());
    }

    public static NotificationEmailTemplate createDefault(NotificationEmailTemplateType notificationEmailTemplateType, String content) {
        return new NotificationEmailTemplate(notificationEmailTemplateType, notificationEmailTemplateType.getDefaultSubject(), content, true, new Date());
    }

    private NotificationEmailTemplate(NotificationEmailTemplateType type, String subject, String content, boolean defaultContent, Date updated) {
        this.type = type;
        this.subject = subject;
        this.content = content;
        this.defaultContent = defaultContent;
        this.updated = updated;
    }

    public NotificationEmailTemplateType getType() {
        return this.type;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isDefaultContent() {
        return this.defaultContent;
    }

    public Date getUpdated() {
        return this.updated;
    }
}

