/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.spaces.Space;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.midori.confluence.plugin.archiving.model.ContentQualityStats;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentQualityStatsManager;
import com.midori.confluence.plugin.archiving.tool.ContentQualityStatsTool;
import com.midori.confluence.plugin.archiving.util.NonBlacklistedGlobalFreshSpacePredicate;
import com.midori.confluence.plugin.archiving.util.SpaceByNameComparator;
import com.midori.confluence.plugin.archiving.web.base.AbstractNonBlacklistedArchivingAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ViewContentQualityStatsAction
extends AbstractNonBlacklistedArchivingAction {
    private LabelManager labelManager;
    private ContentQualityStatsManager contentQualityStatsManager;
    private ContentQualityStatsTool contentQualityStatsTool;

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setContentQualityStatsManager(ContentQualityStatsManager contentQualityStatsManager) {
        this.contentQualityStatsManager = contentQualityStatsManager;
    }

    public ContentQualityStatsTool getContentQualityStatsTool() {
        return this.contentQualityStatsTool;
    }

    public String execute() {
        this.contentQualityStatsTool = this.isGlobal() ? this.buildGlobalContentQualityStatsTool() : this.buildSpaceContentQualityStatsTool();
        return "success";
    }

    private ContentQualityStatsTool buildGlobalContentQualityStatsTool() {
        SpaceByNameComparator spaceComparator = new SpaceByNameComparator();
        TreeSet<Space> uncategorizedSpaces = new TreeSet<Space>(spaceComparator);
        uncategorizedSpaces.addAll(this.spaceHelper.findNonBlacklistedGlobalFreshSpaces());
        List spaceCategories = this.labelManager.getTeamLabels();
        TreeMultimap spacesBySpaceCategories = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)spaceComparator);
        for (Label spaceCategory : spaceCategories) {
            if (spaceCategory.getName().equals("noarchive")) continue;
            Collection spacesInCategory = Collections2.filter((Collection)this.labelManager.getSpacesWithLabel(spaceCategory), (Predicate)NonBlacklistedGlobalFreshSpacePredicate.INSTANCE);
            spacesBySpaceCategories.putAll((Object)spaceCategory, (Iterable)spacesInCategory);
            uncategorizedSpaces.removeAll(spacesInCategory);
        }
        spacesBySpaceCategories.putAll((Object)new Label("<uncategorised>"), uncategorizedSpaces);
        Map<String, ContentQualityStats> statsBySpaces = this.contentQualityStatsManager.getContentQualityStatsBySpaces(ModelUtils.getSpaceKeys(spacesBySpaceCategories.values()));
        return new ContentQualityStatsTool(spacesBySpaceCategories.asMap(), statsBySpaces);
    }

    private ContentQualityStatsTool buildSpaceContentQualityStatsTool() {
        return new ContentQualityStatsTool(null, Collections.singletonMap(this.space.getKey(), this.contentQualityStatsManager.getContentQualityStatsBySpace(this.space.getKey())));
    }
}

