/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task.base;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.model.LongRunningTaskDescriptor;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.SmartProgressMeter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchivingLongRunningTask
extends ConfluenceAbstractLongRunningTask
implements ArchivingLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractArchivingLongRunningTask.class);
    protected PageManager pageManager;
    protected SpaceManager spaceManager;
    protected TransactionTemplate transactionTemplate;
    protected ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager;
    protected ContentArchivingManager contentArchivingManager;
    protected ContentLifecycleActorHelper contentLifecycleActorHelper;
    protected ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    protected ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager;
    protected PluginHelper pluginHelper;
    protected SpaceHelper spaceHelper;
    protected SqlHelper sqlHelper;
    protected Option<Space> space;
    private String taskId;
    private String nodeName;
    private ClusterWideProgressTracker clusterWideProgressTracker;
    private LongRunningTaskDescriptor descriptor;

    public AbstractArchivingLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Option<Space> space, String nodeName) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.contentLifecycleLongRunningTaskManager = contentLifecycleLongRunningTaskManager;
        this.contentArchivingManager = contentArchivingManager;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
        this.contentLifecycleLongRunningTaskResultManager = contentLifecycleLongRunningTaskResultManager;
        this.pluginHelper = pluginHelper;
        this.spaceHelper = spaceHelper;
        this.sqlHelper = sqlHelper;
        this.space = space;
        this.nodeName = nodeName;
        this.progress = new SmartProgressMeter();
    }

    public boolean isReal() {
        return true;
    }

    public final String getNameKey() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public final String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    protected void runInternal() {
        log.debug(String.format("%s task started (version %s)", this.getName(), this.pluginHelper.getPluginVersion()));
        ClusterLock lock = this.contentLifecycleLongRunningTaskManager.getClusterWideLock();
        try {
            if (!lock.tryLock()) {
                log.warn(String.format("%s task exited as failed to acquire cluster-wide lock", this.getName()));
                return;
            }
            log.debug("Cluster-wide lock acquired");
            this.progress = this.createProgressMeter();
            this.clusterWideProgressTracker = new ClusterWideProgressTracker((SmartProgressMeter)this.progress);
            this.descriptor = new LongRunningTaskDescriptor(this.getName(), this.space.isDefined() ? ((Space)this.space.get()).getKey() : null, this.getTaskId(), this.nodeName, System.currentTimeMillis(), (SmartProgressMeter)this.progress);
            this.decorateThreadName();
            if (!this.contentLifecycleStatusHelper.isDisposable()) {
                this.clusterWideProgressTracker.setStatus("Your trial period or commercial license has expired, therefore the app stopped working.");
                this.clusterWideProgressTracker.setCompletedSuccessfully(false);
                return;
            }
            if (PluginHelper.isReadOnlyAccessModeEnabled()) {
                this.clusterWideProgressTracker.setStatus("Confluence is in read-only mode, therefore the task was not executed.");
                this.clusterWideProgressTracker.setCompletedSuccessfully(false);
                log.warn(String.format("%s task exited as Confluence is in read-only mode", this.getName()));
                return;
            }
            try {
                this.clusterWideProgressTracker.setStatus(this.getStartStatusHtml());
                this.execute();
                this.clusterWideProgressTracker.setStatus(this.getCompletedStatusHtml());
                this.clusterWideProgressTracker.markCompleted();
                this.clusterWideProgressTracker.setCompletedSuccessfully(true);
            }
            catch (Exception e) {
                log.error(this.getErrorLogText(), (Throwable)e);
                this.clusterWideProgressTracker.setStatus(this.getErrorStatusHtml(e));
                this.clusterWideProgressTracker.setCompletedSuccessfully(false);
                throw new RuntimeException("Failed to run task", e);
            }
            log.debug(String.format("%s task completed in %s (%ds)", this.getName(), StringUtils.uncapitalize((String)this.getPrettyElapsedTime()), this.getElapsedTime() / 1000L));
        }
        catch (ThreadDeath ex) {
            log.warn(String.format("%s task has been forcibly stopped (via its thread <%s>)", this.getName(), Thread.currentThread().getName()));
            this.clusterWideProgressTracker.setStatus("Task has been forcibly stopped");
            this.clusterWideProgressTracker.setCompletedSuccessfully(false);
        }
        finally {
            try {
                lock.unlock();
                log.debug("Cluster-wide lock released");
            }
            catch (IllegalMonitorStateException e) {
                log.debug("Failed to release cluster-wide lock because another thread owns that");
            }
            catch (Throwable t) {
                log.warn("Failed to release cluster-wide lock", t);
            }
        }
    }

    @Override
    public Option<Space> getSpace() {
        return this.space;
    }

    @Override
    public final boolean isSpaceScoped() {
        return this.space.isDefined();
    }

    public ClusterWideProgressTracker getClusterWideProgressTracker() {
        return this.clusterWideProgressTracker;
    }

    private void decorateThreadName() {
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(oldThreadName + " [CARCH]");
    }

    private void refreshClusterWideTaskDescriptor() {
        if (this.descriptor != null) {
            this.contentLifecycleLongRunningTaskManager.putCurrentlyRunningTaskDescriptor(this.descriptor);
        }
    }

    protected void replaceProgressWith(SmartProgressMeter otherProgress) {
        this.progress = otherProgress;
        this.clusterWideProgressTracker = new ClusterWideProgressTracker(otherProgress);
    }

    public String toString() {
        return String.format("Task #%s \"%s\"", this.taskId, this.getName());
    }

    protected abstract void execute();

    protected abstract SmartProgressMeter createProgressMeter();

    protected abstract String getStartStatusHtml();

    protected abstract String getCompletedStatusHtml();

    protected abstract String getErrorStatusHtml(Exception var1);

    protected abstract String getErrorLogText();

    public class ClusterWideProgressTracker
    implements ProgressTracker {
        private SmartProgressMeter delegate;

        public ClusterWideProgressTracker(SmartProgressMeter delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setInProgressMessage(String message) {
            this.delegate.setInProgressMessage(message);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setPercentage(int count, int total) {
            this.delegate.setPercentage(count, total);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setPercentage(int percentageComplete) {
            this.delegate.setPercentage(percentageComplete);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void incrementCurrentCount() {
            this.delegate.incrementCurrentCount();
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void markCompleted() {
            this.delegate.markCompleted();
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setStatus(String status) {
            this.delegate.setStatus(status);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setCurrentCount(int currentCount) {
            this.delegate.setCurrentCount(currentCount);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setTotalObjects(int total) {
            this.delegate.setTotalObjects(total);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        @Override
        public void setCompletedSuccessfully(boolean completedSuccessfully) {
            this.delegate.setCompletedSuccessfully(completedSuccessfully);
            AbstractArchivingLongRunningTask.this.refreshClusterWideTaskDescriptor();
        }

        public boolean isCompleted() {
            return this.delegate.isCompleted();
        }
    }
}

