/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.util.SQLUtils;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SqlHelper {
    private static Logger log = LoggerFactory.getLogger(SqlHelper.class);
    private final TransactionalExecutorFactory transactionalExecutorFactory = (TransactionalExecutorFactory)ComponentLocator.getComponent(TransactionalExecutorFactory.class);
    private Object pluginHibernateSessionFactory;
    private TransactionTemplate transactionTemplate;

    public SqlHelper(TransactionTemplate transactionTemplate) throws ClassNotFoundException {
        if (this.transactionalExecutorFactory == null) {
            Class<?> pluginHibernateSessionFactoryClass = Class.forName("com.atlassian.hibernate.PluginHibernateSessionFactory");
            this.pluginHibernateSessionFactory = ComponentLocator.getComponent(pluginHibernateSessionFactoryClass);
            this.transactionTemplate = transactionTemplate;
        }
        if (this.transactionalExecutorFactory == null && (this.transactionTemplate == null || this.pluginHibernateSessionFactory == null)) {
            throw new RuntimeException("Failed to resolve SqlHelper dependencies");
        }
    }

    public int executeCountQuery(String query) {
        if (this.transactionalExecutorFactory != null) {
            return (Integer)this.transactionalExecutorFactory.createExecutor().readOnly().execute(connection -> SqlHelper.getCountForQuery(connection, query));
        }
        return (Integer)this.transactionTemplate.execute(() -> {
            try {
                Connection connection = this.getConnection();
                return SqlHelper.getCountForQuery(connection, query);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute SQL query", e);
            }
        });
    }

    @Deprecated
    private Connection getConnection() {
        Method getSessionMethod = ReflectionUtils.findMethod(this.pluginHibernateSessionFactory.getClass(), (String)"getSession");
        Object session = ReflectionUtils.invokeMethod((Method)getSessionMethod, (Object)this.pluginHibernateSessionFactory);
        Method connectionMethod = ReflectionUtils.findMethod(session.getClass(), (String)"connection");
        return (Connection)ReflectionUtils.invokeMethod((Method)connectionMethod, (Object)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCountForQuery(Connection connection, String query) {
        int n;
        ResultSet rs;
        Statement st;
        block5: {
            st = null;
            rs = null;
            st = connection.createStatement();
            rs = st.executeQuery(query);
            if (rs.next()) break block5;
            log.warn("Unable to execute usage info query: no data returned.");
            int n2 = -1;
            SQLUtils.closeResultSetQuietly((ResultSet)rs);
            SQLUtils.closeStatementQuietly((Statement)st);
            return n2;
        }
        try {
            n = rs.getInt(1);
        }
        catch (SQLException e) {
            int n3;
            try {
                log.warn("Unable to execute usage info query: " + query + " - " + e.getMessage(), (Throwable)e);
                n3 = -1;
            }
            catch (Throwable throwable) {
                SQLUtils.closeResultSetQuietly(rs);
                SQLUtils.closeStatementQuietly((Statement)st);
                throw throwable;
            }
            SQLUtils.closeResultSetQuietly((ResultSet)rs);
            SQLUtils.closeStatementQuietly((Statement)st);
            return n3;
        }
        SQLUtils.closeResultSetQuietly((ResultSet)rs);
        SQLUtils.closeStatementQuietly((Statement)st);
        return n;
    }
}

