/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.midori.confluence.plugin.archiving.util.NonBlacklistedGlobalFreshSpacePredicate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceHelper {
    private static Logger log = LoggerFactory.getLogger(SpaceHelper.class);
    public static final String ARCHIVE_SPACE_KEY_SUFFIX = "Archive";
    public static final String ARCHIVE_SPACE_NAME_SUFFIX = " (Archive)";
    private SpaceManager spaceManager;

    public SpaceHelper(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public String getCanonicalSpaceKey(String caseInsensitiveSpaceKey) {
        if (caseInsensitiveSpaceKey != null) {
            Space space = this.spaceManager.getSpace(caseInsensitiveSpaceKey);
            return space != null ? space.getKey() : caseInsensitiveSpaceKey;
        }
        return null;
    }

    public List<Space> findNonBlacklistedGlobalFreshSpaces() {
        long start = System.currentTimeMillis();
        List<Space> spaces = this.findGlobalFreshSpaces();
        ArrayList<Space> filteredSpaces = new ArrayList<Space>(Collections2.filter(spaces, (Predicate)NonBlacklistedGlobalFreshSpacePredicate.INSTANCE));
        log.debug(String.format("%d non-blacklisted fresh global spaces (%d total) found in %d ms", filteredSpaces.size(), spaces.size(), System.currentTimeMillis() - start));
        return filteredSpaces;
    }

    public List<Space> findGlobalFreshSpaces() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).withSpaceStatus(SpaceStatus.CURRENT).build();
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (List spaceList : this.spaceManager.getSpaces(spacesQuery)) {
            spaces.addAll(spaceList);
        }
        return spaces;
    }

    public static String getArchiveSpaceKeyBySpaceKey(String spaceKey) {
        return spaceKey + ARCHIVE_SPACE_KEY_SUFFIX;
    }

    public static String getArchiveSpaceNameBySpaceName(String spaceName) {
        return spaceName + ARCHIVE_SPACE_NAME_SUFFIX;
    }

    public Space findArchiveSpaceByFreshSpace(String spaceKey) {
        return this.spaceManager.getSpace(SpaceHelper.getArchiveSpaceKeyBySpaceKey(spaceKey));
    }
}

