/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleStatusHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleStatusHelper.class);
    private PluginLicenseManager licenseManager;

    public ContentLifecycleStatusHelper(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isDisposable() {
        if (ConfluenceSystemProperties.isDevMode()) {
            return true;
        }
        LifecycleStatus lifecycleStatus = this.getCurrentLifecycleStatus().getLifecycleStatus();
        return lifecycleStatus == LifecycleStatus.LIMITED || lifecycleStatus == LifecycleStatus.COMPLETE;
    }

    public boolean isDraft() {
        if (ConfluenceSystemProperties.isDevMode()) {
            return false;
        }
        LifecycleStatus lifecycleStatus = this.getCurrentLifecycleStatus().getLifecycleStatus();
        return lifecycleStatus == LifecycleStatus.LIMITED;
    }

    public boolean isComposite() {
        PluginLicense context = this.getCurrentLifecycleStatus().getContext();
        return context != null && context.isDataCenter();
    }

    private CurrentLifecycleStatus getCurrentLifecycleStatus() {
        try {
            if (this.licenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                if (pluginLicense.getError().isDefined()) {
                    log.warn(String.format("Error with %s license: %s. %s", ContentLifecycleStatusHelper.getPluginName(), ((LicenseError)pluginLicense.getError().get()).name(), ContentLifecycleStatusHelper.getVisitText()));
                    return CurrentLifecycleStatus.error(pluginLicense);
                }
                return CurrentLifecycleStatus.installed(pluginLicense);
            }
            log.warn(String.format("No license is installed for %s. %s", ContentLifecycleStatusHelper.getPluginName(), ContentLifecycleStatusHelper.getVisitText()));
            return CurrentLifecycleStatus.error(null);
        }
        catch (LicenseException ex) {
            log.error(String.format("Failed to check license for %s", ContentLifecycleStatusHelper.getPluginName()), (Throwable)ex);
            return CurrentLifecycleStatus.error(null);
        }
    }

    private static String getPluginName() {
        return "Better Content Archiving for Confluence";
    }

    private static String getVisitText() {
        return "Purchase a supported license at https://www.atlassian.com/purchase/addon/com.midori.confluence.plugin.archiving or get a free trial license at https://www.midori-global.com/products/better-content-archiving-for-confluence/data-center/buy#try or contact info@midori-global.com";
    }

    private static class CurrentLifecycleStatus {
        private final PluginLicense pluginLicense;
        private final LifecycleStatus lifecycleStatus;

        public static CurrentLifecycleStatus error(PluginLicense pluginLicense) {
            return new CurrentLifecycleStatus(pluginLicense, true);
        }

        public static CurrentLifecycleStatus installed(PluginLicense pluginLicense) {
            return new CurrentLifecycleStatus(pluginLicense, false);
        }

        private CurrentLifecycleStatus(PluginLicense pluginLicense, boolean error) {
            this.pluginLicense = pluginLicense;
            this.lifecycleStatus = error ? LifecycleStatus.ERROR_OR_MISSING : (pluginLicense.isEvaluation() ? LifecycleStatus.LIMITED : LifecycleStatus.COMPLETE);
        }

        public PluginLicense getContext() {
            return this.pluginLicense;
        }

        public LifecycleStatus getLifecycleStatus() {
            return this.lifecycleStatus;
        }
    }

    private static enum LifecycleStatus {
        LIMITED,
        COMPLETE,
        ERROR_OR_MISSING;

    }
}

