/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import java.util.Map;

public class ContentArchivingExecutionSpecification {
    private ContentArchivingConfiguration configuration;
    private Space space;
    private final Map<Page, PageArchiving> freshPagesToArchive;

    public ContentArchivingExecutionSpecification(ContentArchivingConfiguration configuration, Space space, Map<Page, PageArchiving> freshPagesToArchive) {
        if (space == null) {
            throw new IllegalArgumentException("Space must not be null");
        }
        if (freshPagesToArchive == null) {
            throw new IllegalArgumentException("Map of fresh pages must not be null");
        }
        for (Page page : freshPagesToArchive.keySet()) {
            if (space.equals((Object)page.getSpace())) continue;
            throw new IllegalArgumentException("All fresh pages must belong to the same space");
        }
        this.configuration = configuration;
        this.space = space;
        this.freshPagesToArchive = freshPagesToArchive;
    }

    public ContentArchivingConfiguration getConfiguration() {
        return this.configuration;
    }

    public Space getSpace() {
        return this.space;
    }

    public Map<Page, PageArchiving> getFreshPagesToArchive() {
        return this.freshPagesToArchive;
    }

    public boolean hasNoPagesToArchive() {
        return this.freshPagesToArchive.isEmpty();
    }
}

