/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.eventindex;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ao.ContentUpdateEventAo;
import com.midori.confluence.plugin.archiving.model.type.PageUpdateEventType;
import com.midori.confluence.plugin.archiving.service.eventindex.AbstractContentEventTracker;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentUpdateTracker
extends AbstractContentEventTracker<ContentUpdate> {
    private static Logger log = LoggerFactory.getLogger(ContentUpdateTracker.class);

    public ContentUpdateTracker(ActiveObjects ao, CacheManager cacheManager, TransactionTemplate transactionTemplate) {
        super(ao, cacheManager, transactionTemplate);
    }

    @Override
    protected String getEventName() {
        return "update";
    }

    @Override
    protected Class<? extends RawEntity> getActiveObjectsClass() {
        return ContentUpdateEventAo.class;
    }

    @Override
    protected ContentUpdate fromAo(RawEntity rawEntity) {
        return ContentUpdate.fromAo((ContentUpdateEventAo)rawEntity);
    }

    @Override
    protected ContentUpdate fromSerializedFormat(String serialized) {
        return new ContentUpdate(serialized);
    }

    @Override
    protected String getOriginatorNameDbField() {
        return "UPDATER_NAME";
    }

    @Override
    protected String getDateDbField() {
        return "UPDATE_DATE";
    }

    @Override
    protected List<DBParam> createDbParams(Long pageId, ContentUpdate event) {
        List<DBParam> params = super.createDbParams(pageId, event);
        params.add(new DBParam("TYPE", (Object)event.getType().getCode()));
        return params;
    }

    public void onContentEvent(String userName, ContentEntityObject ceo, PageUpdateEventType updateEventType) {
        Date currentDate = new Date();
        this.enjournal(ceo.getId(), ContentUpdate.newGeneric(userName, currentDate, updateEventType));
        if (ceo instanceof Page) {
            Page currentPage = (Page)ceo;
            for (Page page : currentPage.getAncestors()) {
                this.enjournal(page.getId(), ContentUpdate.newGeneric(userName, currentDate, PageUpdateEventType.CHILD_UPDATED));
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

