/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.ao.upgrade.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.spring.container.ContainerManager;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ao.ContentArchivingConfigurationAo;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyContentOwnersInitializerTask
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(NotifyContentOwnersInitializerTask.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects ao) {
        try {
            log.info("Initializing content owner notification settings in content archiving configurations");
            ao.migrate(new Class[]{ContentArchivingConfigurationAo.class});
            log.info("ContentArchivingConfigurationAo entity migrated");
            SpaceManager spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager", SpaceManager.class);
            ContentArchivingConfigurationManager manager = new ContentArchivingConfigurationManager(ao, spaceManager);
            log.info("Updating content archiving configurations");
            List<ContentArchivingConfiguration> configurations = manager.findAllConfigurations();
            for (ContentArchivingConfiguration configuration : configurations) {
                configuration.setNotifyOwnersOnPageView(false);
                configuration.setNotifyOwnersOnPageExpiration(false);
                configuration.setNotifyOwnersOnPageArchiving(false);
                manager.saveConfiguration(configuration);
            }
            log.info(String.format("%d content archiving configurations were updated successfully", configurations.size()));
        }
        catch (RuntimeException ex) {
            log.error("Failed to initialize content owner notification settings", (Throwable)ex);
            throw ex;
        }
    }
}

