/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ComponentNotFoundException;
import com.atlassian.spring.container.ContainerManager;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginHelper {
    private static Logger log = LoggerFactory.getLogger(PluginHelper.class);
    private PluginAccessor pluginAccessor;

    public PluginHelper(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public String getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin("com.midori.confluence.plugin.archiving");
        return plugin != null ? plugin.getPluginInformation().getVersion() : null;
    }

    public static boolean isReadOnlyAccessModeEnabled() {
        boolean isReadOnlyAccessModeEnabled = false;
        try {
            Object accessModeService = ContainerManager.getInstance().getContainerContext().getComponent((Object)"accessModeService");
            if (accessModeService != null) {
                isReadOnlyAccessModeEnabled = (Boolean)accessModeService.getClass().getMethod("isReadOnlyAccessModeEnabled", new Class[0]).invoke(accessModeService, new Object[0]);
            }
        }
        catch (ComponentNotFoundException accessModeService) {
        }
        catch (Exception ex) {
            log.error("Failed to check read-only mode", (Throwable)ex);
        }
        return isReadOnlyAccessModeEnabled;
    }

    public static Level setLoggingLevel(String loggerName, Level level) {
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)loggerName);
        Level oldLevel = logger.getLevel();
        logger.setLevel(level);
        return oldLevel;
    }
}

