/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.replication;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.ReplicationUtils;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class SpaceReplicator {
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private PageReplicator pageReplicator;
    private static Set<String> READ_PERMISSION_TYPES = ImmutableSet.of((Object)"VIEWSPACE", (Object)"EXPORTSPACE", (Object)"SETSPACEPERMISSIONS");

    public SpaceReplicator(SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, PageReplicator pageReplicator) {
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.pageReplicator = pageReplicator;
    }

    public Space replicate(String spaceKey, String newSpaceKey, String newSpaceName) {
        Space space = this.spaceManager.getSpace(spaceKey);
        Space newSpace = this.spaceManager.createSpace(newSpaceKey, newSpaceName, space.getDescription().getBodyAsString(), (User)AuthenticatedUserThreadLocal.get());
        if (newSpace == null || newSpace.getId() <= 0L || StringUtils.isBlank((String)newSpace.getKey())) {
            throw new IllegalStateException(String.format("Archive space created for <%s> is NULL or has zero ID or has blank key", spaceKey));
        }
        ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)space, (ConfluenceEntityObject)newSpace);
        this.spaceManager.saveSpace(newSpace);
        Page homePage = newSpace.getHomePage();
        if (homePage != null) {
            this.pageReplicator.silentlyRemove(homePage);
        }
        this.copyReadPermissions(space, newSpace);
        return newSpace;
    }

    public void hide(Space archiveSpace) {
        this.spaceManager.archiveSpace(archiveSpace);
    }

    private void copyReadPermissions(Space fromSpace, Space toSpace) {
        this.spacePermissionManager.removeAllPermissions(toSpace);
        this.setPermissionsForSpace(toSpace, this.getCopiableReadPermissionsBySpace(fromSpace));
    }

    private Collection<SpacePermission> getCopiableReadPermissionsBySpace(Space fromSpace) {
        return Collections2.filter((Collection)fromSpace.getPermissions(), (Predicate)new Predicate<SpacePermission>(){

            public boolean apply(SpacePermission spacePermission) {
                boolean isReadPermission = READ_PERMISSION_TYPES.contains(spacePermission.getType());
                return !spacePermission.isAnonymousPermission() && !spacePermission.isAuthenticatedUsersPermission() && isReadPermission;
            }
        });
    }

    private void setPermissionsForSpace(Space toSpace, Collection<SpacePermission> permissions) {
        for (SpacePermission permission : permissions) {
            SpacePermission newPermission = new SpacePermission();
            newPermission.setSpace(toSpace);
            newPermission.setType(permission.getType());
            newPermission.setGroup(permission.getGroup());
            newPermission.setUserSubject(permission.getUserSubject());
            ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)permission, (ConfluenceEntityObject)newPermission);
            this.spacePermissionManager.savePermission(newPermission);
        }
    }
}

