/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.type;

public enum NotificationEmailTemplateType {
    NON_VIEWED_PAGES("non-viewed", "${pages.size()} page(s) not viewed recently", "non-viewed-pages-notification.vm"),
    EXPIRED_PAGES("expired", "${pages.size()} page(s) expired", "expired-pages-notification.vm"),
    ARCHIVED_PAGES("archived", "${pages.size()} page(s) archived", "archived-pages-notification.vm"),
    SKIPPED_PAGES("skipped", "${pages.size()} page(s) not archived (missing reason)", "skipped-pages-notification.vm"),
    DISCUSSED_PAGES("discussed", "Discussion on \"${page.title}\"", "discussed-pages-notification.vm");

    private final String shortName;
    private final String defaultSubject;
    private final String defaultTemplateFileName;

    private NotificationEmailTemplateType(String shortName, String defaultSubject, String defaultTemplateFileName) {
        this.shortName = shortName;
        this.defaultSubject = defaultSubject;
        this.defaultTemplateFileName = defaultTemplateFileName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDefaultSubject() {
        return this.defaultSubject;
    }

    public String getDefaultTemplateFileName() {
        return this.defaultTemplateFileName;
    }

    public static NotificationEmailTemplateType fromShortName(String shortName) {
        for (NotificationEmailTemplateType notificationEmailType : NotificationEmailTemplateType.values()) {
            if (!notificationEmailType.getShortName().equals(shortName)) continue;
            return notificationEmailType;
        }
        return null;
    }
}

