/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest.base;

import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CrowdEntityPickerResource<T, U> {
    private static Logger log = LoggerFactory.getLogger(CrowdEntityPickerResource.class);
    private static final int MIN_TERM_LENGTH = 3;
    protected static final int MAX_RESULT_COUNT = 10;
    private final CrowdService crowdService;

    protected CrowdEntityPickerResource(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    protected Response getOptionsByTerm(String term) {
        log.trace(String.format("Searching for %s with term <%s>", this.getEntityNamePlural(), term));
        if (term == null) {
            throw new IllegalArgumentException("Term is required");
        }
        if ((term = term.trim()).length() < 3) {
            throw new IllegalArgumentException(String.format("Term must be at least %d characters long", 3));
        }
        long startTime = System.currentTimeMillis();
        List<T> entities = this.findEntitiesMatching(term);
        log.trace(String.format("%d %s found in %d ms", entities.size(), this.getEntityNamePlural(), System.currentTimeMillis() - startTime));
        return Response.ok(entities).build();
    }

    private List<T> findEntitiesMatching(String term) {
        Query<String> query = this.buildTermMatchingQuery(term);
        ImmutableList matches = ImmutableList.copyOf((Iterable)this.crowdService.search(query));
        ArrayList<T> entities = new ArrayList<T>();
        for (String match : matches) {
            U entity = this.findEntityByName(match);
            if (entity == null) continue;
            entities.add(this.entityToRestModel(entity));
        }
        return entities;
    }

    protected abstract String getEntityNamePlural();

    protected abstract Query<String> buildTermMatchingQuery(String var1) throws ServiceException;

    protected abstract U findEntityByName(String var1);

    protected abstract T entityToRestModel(U var1);
}

