/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventDataProvider;
import com.midori.confluence.plugin.archiving.service.persistence.ContentQualityStatsManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractQualityStatsRelatedLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.LongRunningTaskStep;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.SmartProgressMeter;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentQualityAnalyzerLongRunningTask
extends AbstractQualityStatsRelatedLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(ContentQualityAnalyzerLongRunningTask.class);
    private ContentEventDataProvider contentEventDataProvider;
    private ContentQualityStatsManager contentQualityStatsManager;
    private LongRunningTaskStep step = new LongRunningTaskStep(){

        @Override
        public String getName() {
            return "Content Quality Analysis";
        }

        @Override
        public boolean shouldBeExecuted(Space space) {
            return true;
        }

        @Override
        public void execute(Space space, int totalSpaceCount, int spaceIndex, ProgressTracker progressTracker) {
            if (ContentQualityAnalyzerLongRunningTask.this.contentEventDataProvider.isIndexed(space)) {
                log.debug(String.format("Calculating content quality stats for <%s>", space.getKey()));
                Space archiveSpace = ContentQualityAnalyzerLongRunningTask.this.spaceHelper.findArchiveSpaceByFreshSpace(space.getKey());
                int numberOfPages = ContentQualityAnalyzerLongRunningTask.this.countPages(space);
                int numberOfExpiredPages = ContentQualityAnalyzerLongRunningTask.this.contentArchivingManager.findExpiredPages(space).keySet().size();
                int numberOfNotViewedPages = ContentQualityAnalyzerLongRunningTask.this.contentArchivingManager.findNotViewedPages(space).keySet().size();
                int numberOfArchivedPages = archiveSpace != null ? ContentQualityAnalyzerLongRunningTask.this.countPages(archiveSpace) : 0;
                ContentQualityAnalyzerLongRunningTask.this.contentQualityStatsManager.saveContentQualityStats(space, numberOfPages, numberOfExpiredPages, numberOfNotViewedPages, numberOfArchivedPages);
            } else {
                log.warn(String.format("Space <%s> has never been indexed, please run the content event indexing before calculating quality statistics on this space", space.getKey()));
            }
        }
    };

    public ContentQualityAnalyzerLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Option<Space> space, String nodeName, ContentEventDataProvider contentEventDataProvider, ContentQualityStatsManager contentQualityStatsManager) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, space, nodeName);
        this.contentEventDataProvider = contentEventDataProvider;
        this.contentQualityStatsManager = contentQualityStatsManager;
    }

    @Override
    public String getName() {
        return "Content Quality Analysis";
    }

    @Override
    protected String getStartStatusHtml() {
        return "Analyzing content quality...";
    }

    @Override
    protected SmartProgressMeter createProgressMeter() {
        return new SmartProgressMeter("Analyzing content quality (%s of %s spaces)...", this.getCompletedStatusHtml());
    }

    @Override
    public String getCompletedStatusHtml() {
        return "Content quality analysis completed.";
    }

    @Override
    protected String getErrorStatusHtml(Exception cause) {
        return "Failed to analyze content quality. Please check your log files: " + cause.getMessage();
    }

    @Override
    protected String getErrorLogText() {
        return "Failed to analyze content quality";
    }

    @Override
    protected void beforeExecution(List<Space> allSpacesToProcess, int totalNumberOfPages) {
    }

    @Override
    protected List<? extends LongRunningTaskStep> getSteps() {
        return Collections.singletonList(this.step);
    }
}

