/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableList;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ContentArchivingStats;
import com.midori.confluence.plugin.archiving.model.ContentExpirationStats;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.ContentViewStats;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.SystemSettingsManager;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionResult;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataReducer;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPageArchiving;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractSpaceOrientedLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.LongRunningTaskStep;
import com.midori.confluence.plugin.archiving.service.task.progress.NoOpProgressTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.SmartProgressMeter;
import com.midori.confluence.plugin.archiving.service.task.result.AggregatedContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.service.task.result.ContentArchivingLongRunningTaskResult;
import com.midori.confluence.plugin.archiving.util.limited.LimitedList;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentArchivingLongRunningTask
extends AbstractSpaceOrientedLongRunningTask {
    private static Logger log = LoggerFactory.getLogger(ContentArchivingLongRunningTask.class);
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentArchivingExecutionResult pageArchivingResult;
    private ContentViewStats pageViewStats;
    private Map<LightSpace, Map<LightPage, ContentView>> spacesToNotViewedPages;
    private ContentExpirationStats pageExpirationStats;
    private Map<LightSpace, Map<LightPage, ContentUpdate>> spacesToExpiredPages;
    private LongRunningTaskStep pageArchivingStep = new LongRunningTaskStep(){

        @Override
        public String getName() {
            return "Page Archiving";
        }

        @Override
        public boolean shouldBeExecuted(Space space) {
            ContentArchivingConfiguration config = ContentArchivingLongRunningTask.this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            return config.isPageArchivingOfAnyTypeEnabled();
        }

        @Override
        public void execute(Space space, int totalSpaceCount, int spaceIndex, ProgressTracker progressTracker) {
            ProgressTracker archivingProgressTracker = ContentArchivingLongRunningTask.this.progressTrackerGranularity == AbstractSpaceOrientedLongRunningTask.ProgressTrackerGranularity.PAGE ? progressTracker : new NoOpProgressTracker();
            ContentArchivingExecutionContext context = ContentArchivingLongRunningTask.this.contentArchivingManager.archiveSpace(space, archivingProgressTracker);
            ContentArchivingLongRunningTask.this.pageArchivingResult.addExecutionContext(context);
        }
    };
    private LongRunningTaskStep viewTrackingStep = new LongRunningTaskStep(){

        @Override
        public String getName() {
            return "View Tracking";
        }

        @Override
        public boolean shouldBeExecuted(Space space) {
            ContentArchivingConfiguration config = ContentArchivingLongRunningTask.this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            return config.isPageViewTrackingOfAnyTypeEnabled();
        }

        @Override
        public void execute(Space space, int totalSpaceCount, int spaceIndex, ProgressTracker progressTracker) {
            Map<Page, ContentView> notViewedPages = ContentArchivingLongRunningTask.this.contentArchivingManager.findNotViewedPages(space);
            ContentArchivingLongRunningTask.this.pageViewStats.setSpaces(spaceIndex);
            ContentArchivingLongRunningTask.this.pageViewStats.addNotViewedPagesForSpace(space.getKey(), notViewedPages.size());
            ContentArchivingLongRunningTask.this.spacesToNotViewedPages.put(LightSpace.fromSpace(space), DataReducer.lightenPageKeyedMap(notViewedPages));
        }
    };
    private LongRunningTaskStep expirationTrackingStep = new LongRunningTaskStep(){

        @Override
        public String getName() {
            return "Expiration Tracking";
        }

        @Override
        public boolean shouldBeExecuted(Space space) {
            ContentArchivingConfiguration config = ContentArchivingLongRunningTask.this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            return config.isPageExpirationTrackingOfAnyTypeEnabled();
        }

        @Override
        public void execute(Space space, int totalSpaceCount, int spaceIndex, ProgressTracker progressTracker) {
            Map<Page, ContentUpdate> expiredPages = ContentArchivingLongRunningTask.this.contentArchivingManager.findExpiredPages(space);
            ContentArchivingLongRunningTask.this.pageExpirationStats.setSpaces(spaceIndex);
            ContentArchivingLongRunningTask.this.pageExpirationStats.addExpiredPagesForSpace(space.getKey(), expiredPages.size());
            ContentArchivingLongRunningTask.this.spacesToExpiredPages.put(LightSpace.fromSpace(space), DataReducer.lightenPageKeyedMap(expiredPages));
        }
    };

    public ContentArchivingLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Option<Space> space, String nodeName, ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, space, nodeName);
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    @Override
    public String getName() {
        return "Content Archiving";
    }

    @Override
    protected String getStartStatusHtml() {
        return "Archiving content...";
    }

    @Override
    protected SmartProgressMeter createProgressMeter() {
        return new SmartProgressMeter("Archiving content...", this.getCompletedStatusHtml());
    }

    @Override
    public String getCompletedStatusHtml() {
        return "Content archiving completed.";
    }

    @Override
    protected String getErrorStatusHtml(Exception cause) {
        return "Failed to archive content. Please check your log files: " + cause.getMessage();
    }

    @Override
    protected String getErrorLogText() {
        return "Failed to archive content";
    }

    @Override
    protected List<Space> getSpacesToExecuteOn() {
        LinkedHashSet<Space> allSpaces = new LinkedHashSet<Space>();
        if (!this.isSpaceScoped()) {
            allSpaces.addAll(this.contentArchivingManager.findScheduledArchivingEnabledSpaces());
            allSpaces.addAll(this.contentArchivingManager.findScheduledPageViewTrackedSpaces());
            allSpaces.addAll(this.contentArchivingManager.findScheduledPageExpirationTrackedSpaces());
        } else {
            Space currentSpace = (Space)this.space.get();
            Option<Space> archivingEnabledSpace = this.contentArchivingManager.findSpaceByKeyIfArchivingEnabled(currentSpace);
            allSpaces.addAll((Collection<Space>)ImmutableList.copyOf((Iterator)archivingEnabledSpace.iterator()));
            Option<Space> viewTrackedSpace = this.contentArchivingManager.findSpaceByKeyIfPageViewTracked(currentSpace);
            allSpaces.addAll((Collection<Space>)ImmutableList.copyOf((Iterator)viewTrackedSpace.iterator()));
            Option<Space> expirationTrackedSpace = this.contentArchivingManager.findSpaceByKeyIfPageExpirationTracked(currentSpace);
            allSpaces.addAll((Collection<Space>)ImmutableList.copyOf((Iterator)expirationTrackedSpace.iterator()));
        }
        return new ArrayList<Space>(allSpaces);
    }

    @Override
    protected void beforeExecution(List<Space> allSpacesToProcess, int totalNumberOfPages) {
        this.pageArchivingResult = new ContentArchivingExecutionResult();
        this.pageViewStats = new ContentViewStats();
        this.spacesToNotViewedPages = new LinkedHashMap<LightSpace, Map<LightPage, ContentView>>(allSpacesToProcess.size());
        this.pageExpirationStats = new ContentExpirationStats();
        this.spacesToExpiredPages = new LinkedHashMap<LightSpace, Map<LightPage, ContentUpdate>>(allSpacesToProcess.size());
        if (allSpacesToProcess.size() == 1) {
            this.getClusterWideProgressTracker().setTotalObjects(totalNumberOfPages);
            this.getClusterWideProgressTracker().setInProgressMessage("Archiving content (%s of %s pages)...");
            this.progressTrackerGranularity = AbstractSpaceOrientedLongRunningTask.ProgressTrackerGranularity.PAGE;
        } else {
            this.getClusterWideProgressTracker().setTotalObjects(allSpacesToProcess.size());
            this.getClusterWideProgressTracker().setInProgressMessage("Archiving content (%s of %s spaces)...");
            this.progressTrackerGranularity = AbstractSpaceOrientedLongRunningTask.ProgressTrackerGranularity.SPACE;
        }
    }

    @Override
    protected List<? extends LongRunningTaskStep> getSteps() {
        return Arrays.asList(this.pageArchivingStep, this.viewTrackingStep, this.expirationTrackingStep);
    }

    @Override
    protected void afterExecution(List<Space> allSpacesProcessed) {
        ContentArchivingStats contentArchivingStats = this.doPostArchivingActions();
        this.doPostViewTrackingActions();
        this.doPostExpirationTrackingActions();
        AggregatedContentArchivingConfiguration config = AggregatedContentArchivingConfiguration.allDisabled();
        for (Space space : allSpacesProcessed) {
            config.merge(this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey()));
        }
        this.contentLifecycleLongRunningTaskResultManager.putResult(this.getTaskId(), new ContentArchivingLongRunningTaskResult(LightSpace.fromSpaces(allSpacesProcessed), config, contentArchivingStats, this.pageViewStats, this.pageExpirationStats));
    }

    private ContentArchivingStats doPostArchivingActions() {
        log.debug(String.format("Creating archiving events for %d spaces", this.pageArchivingResult.getFreshSpaces().size()));
        LimitedMap<LightSpace, LimitedList<Long>> limitedSpacesToArchivedPageIds = DataReducer.limitFlattenSpaceKeyedPageKeyedMap(this.pageArchivingResult.getArchivePagesByFreshSpace(), SystemSettingsManager.getEventsMaxSpaces(), SystemSettingsManager.getEventsMaxPagesPerSpace());
        LimitedMap<LightSpace, LimitedList<Long>> limitedSpacesToSkippedPageIds = DataReducer.limitFlattenSpaceKeyedPageKeyedMap(this.pageArchivingResult.getSkippedPagesByFreshSpace(), SystemSettingsManager.getEventsMaxSpaces(), SystemSettingsManager.getEventsMaxPagesPerSpace());
        this.contentArchivingManager.createArchivingEvents(this.pageArchivingResult.getFreshSpaces(), limitedSpacesToArchivedPageIds, limitedSpacesToSkippedPageIds);
        log.debug(String.format("Enqueuing notification emails for %d spaces", this.pageArchivingResult.getFreshSpaces().size()));
        LimitedMap<LightSpace, LimitedMap<LightPage, LightPageArchiving>> limitedArchivedPages = DataReducer.limitSpaceKeyedPageKeyedMap(this.pageArchivingResult.getArchivePagesByFreshSpace(), SystemSettingsManager.getNotificationsMaxSpaces(), SystemSettingsManager.getNotificationsMaxPagesPerSpace());
        LimitedMap<LightSpace, LimitedMap<LightPage, LightPageArchiving>> limitedSkippedPages = DataReducer.limitSpaceKeyedPageKeyedMap(this.pageArchivingResult.getSkippedPagesByFreshSpace(), SystemSettingsManager.getNotificationsMaxSpaces(), SystemSettingsManager.getNotificationsMaxPagesPerSpace());
        ContentArchivingStats contentArchivingStats = this.contentArchivingManager.sendArchivedPagesNotificationEmails(this.pageArchivingResult, limitedArchivedPages, limitedSkippedPages);
        log.info(String.format("Page archiving done: %d spaces scanned", contentArchivingStats.getSpaces()));
        log.info(String.format("    %d pages were copied / moved", contentArchivingStats.getPagesCreatedOrSynched()));
        log.info(String.format("        %d pages were newly created / moved", contentArchivingStats.getPagesCreated()));
        log.info(String.format("        %d pages were updated to the current version", contentArchivingStats.getPagesSynched()));
        log.info(String.format("        %d parent pages were newly created / moved", contentArchivingStats.getParentsCreated()));
        log.info(String.format("        %d parent pages were updated to the current version", contentArchivingStats.getParentsSynched()));
        log.info(String.format("    %d pages were trashed", contentArchivingStats.getPagesTrashed()));
        log.info(String.format("    %d pages were skipped", contentArchivingStats.getPagesSkipped()));
        log.info(String.format("    %d mails were sent", contentArchivingStats.getEmailsSent()));
        log.info(String.format("    %d errors%s", contentArchivingStats.getErrors().size(), contentArchivingStats.getErrors().isEmpty() ? "" : " (check the log!)"));
        return contentArchivingStats;
    }

    private void doPostViewTrackingActions() {
        log.debug(String.format("Enqueuing view notification emails for %d spaces", this.spacesToNotViewedPages.size()));
        LimitedMap<LightSpace, LimitedMap<LightPage, ContentView>> limitedSpacesToNotViewedPages = DataReducer.limitSpaceKeyedPageKeyedMap(this.spacesToNotViewedPages, SystemSettingsManager.getNotificationsMaxSpaces(), SystemSettingsManager.getNotificationsMaxPagesPerSpace());
        int emailsSent = this.contentArchivingManager.sendNotViewedPagesNotificationEmails(limitedSpacesToNotViewedPages);
        this.pageViewStats.addEmailsSent(emailsSent);
        log.info(String.format("Page view tracking done: %d spaces scanned", this.pageViewStats.getSpaces()));
        log.info(String.format("    %d not-viewed pages found", this.pageViewStats.getNotViewedPages()));
        log.info(String.format("    %d mails were sent", this.pageViewStats.getEmailsSent()));
    }

    private void doPostExpirationTrackingActions() {
        log.debug(String.format("Creating page expiration events for %d spaces", this.spacesToExpiredPages.size()));
        LimitedMap<LightSpace, LimitedList<Long>> limitedSpacesToExpiredPageIds = DataReducer.limitFlattenSpaceKeyedPageKeyedMap(this.spacesToExpiredPages, SystemSettingsManager.getEventsMaxSpaces(), SystemSettingsManager.getEventsMaxPagesPerSpace());
        this.contentArchivingManager.createExpirationEvents(limitedSpacesToExpiredPageIds);
        log.debug(String.format("Enqueuing page expiration notification emails for %d spaces", this.spacesToExpiredPages.size()));
        LimitedMap<LightSpace, LimitedMap<LightPage, ContentUpdate>> limitedSpacesToExpiredPages = DataReducer.limitSpaceKeyedPageKeyedMap(this.spacesToExpiredPages, SystemSettingsManager.getNotificationsMaxSpaces(), SystemSettingsManager.getNotificationsMaxPagesPerSpace());
        int emailsSent = this.contentArchivingManager.sendExpiredPagesNotificationEmails(limitedSpacesToExpiredPages);
        this.pageExpirationStats.addEmailsSent(emailsSent);
        log.info(String.format("Page expiration done: %d spaces scanned", this.pageExpirationStats.getSpaces()));
        log.info(String.format("    %d expired pages found", this.pageExpirationStats.getExpiredPages()));
        log.info(String.format("    %d mails were sent", this.pageExpirationStats.getEmailsSent()));
    }
}

