/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support.reduce;

import com.midori.confluence.plugin.archiving.model.Anonymizable;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.SystemSettingsManager;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAnonymizer {
    private static Logger log = LoggerFactory.getLogger(DataAnonymizer.class);

    public static <T extends Anonymizable<?>> LimitedMap<LightSpace, LimitedMap<LightPage, T>> anonymizeSpaceKeyedPageKeyedMap(LimitedMap<LightSpace, LimitedMap<LightPage, T>> spacesToPageKeyedMaps) {
        if (!SystemSettingsManager.isHideLastViewer() && !SystemSettingsManager.isHideLastUpdater()) {
            return spacesToPageKeyedMaps;
        }
        LinkedHashMap anonymizedSpacesToPageKeyedMaps = new LinkedHashMap();
        int totalCount = ModelUtils.getLimitedMapValuedLimitedMapSize(spacesToPageKeyedMaps);
        long start = System.currentTimeMillis();
        for (LightSpace space : spacesToPageKeyedMaps.keySet()) {
            LimitedMap<LightPage, T> pageKeyedMap = spacesToPageKeyedMaps.get(space);
            LimitedMap<LightPage, Anonymizable> anonymizedPageKeyedMap = new LimitedMap<LightPage, Anonymizable>(new LinkedHashMap(), pageKeyedMap.size());
            for (LightPage page : pageKeyedMap.keySet()) {
                Anonymizable anonymizedEvent = DataAnonymizer.anonymizeEvent((Anonymizable)pageKeyedMap.get(page));
                anonymizedPageKeyedMap.put(page, anonymizedEvent);
            }
            anonymizedSpacesToPageKeyedMaps.put(space, anonymizedPageKeyedMap);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("%d items anonymized in %d ms", totalCount, System.currentTimeMillis() - start));
        }
        return new LimitedMap<LightSpace, LimitedMap<LightPage, T>>(anonymizedSpacesToPageKeyedMaps, spacesToPageKeyedMaps.size());
    }

    public static <T extends Anonymizable<?>> T anonymizeEvent(T event) {
        boolean shouldAnonymize = !(event instanceof ContentView) && SystemSettingsManager.isHideLastUpdater() || event instanceof ContentView && SystemSettingsManager.isHideLastViewer();
        return (T)(shouldAnonymize ? (Anonymizable)event.anonymized() : event);
    }
}

