/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemSettingsManager {
    private static Logger log = LoggerFactory.getLogger(SystemSettingsManager.class);
    private static final String SETTING_PROPERTY_NAME_PREFIX = "carch.";
    private static final int eventsMaxSpaces = SystemSettingsManager.getPropertyValue("carch.events.maxSpaces", 1000, new IntegerPropertyExtractor());
    private static final int eventsMaxPagesPerSpace = SystemSettingsManager.getPropertyValue("carch.events.maxPagesPerSpace", 200, new IntegerPropertyExtractor());
    private static final int notificationsMaxSpaces = SystemSettingsManager.getPropertyValue("carch.notifications.maxSpaces", 1000, new IntegerPropertyExtractor());
    private static final int notificationsMaxPagesPerSpace = SystemSettingsManager.getPropertyValue("carch.notifications.maxPagesPerSpace", 100000, new IntegerPropertyExtractor());
    private static final int emailsMaxSpaces = SystemSettingsManager.getPropertyValue("carch.emails.maxSpaces", 200, new IntegerPropertyExtractor());
    private static final int emailsMaxPagesPerSpace = SystemSettingsManager.getPropertyValue("carch.emails.maxPagesPerSpace", 100, new IntegerPropertyExtractor());
    private static final boolean hideLastViewer = SystemSettingsManager.getPropertyValue("carch.ui.hideLastViewer", false, new BooleanPropertyExtractor());
    private static final boolean hideLastUpdater = SystemSettingsManager.getPropertyValue("carch.ui.hideLastUpdater", false, new BooleanPropertyExtractor());

    public static int getEventsMaxSpaces() {
        return eventsMaxSpaces;
    }

    public static int getEventsMaxPagesPerSpace() {
        return eventsMaxPagesPerSpace;
    }

    public static int getNotificationsMaxSpaces() {
        return notificationsMaxSpaces;
    }

    public static int getNotificationsMaxPagesPerSpace() {
        return notificationsMaxPagesPerSpace;
    }

    public static int getEmailsMaxSpaces() {
        return emailsMaxSpaces;
    }

    public static int getEmailsMaxPagesPerSpace() {
        return emailsMaxPagesPerSpace;
    }

    public static boolean isHideLastViewer() {
        return hideLastViewer;
    }

    public static boolean isHideLastUpdater() {
        return hideLastUpdater;
    }

    private static <T> T getPropertyValue(String propertyName, T defaultValue, PropertyExtractor<T> propertyExtractor) {
        T value = propertyExtractor.extract(propertyName);
        if (value == null) {
            value = defaultValue;
            log.debug(String.format("System property <%s> is NOT set, using %s (default value)", propertyName, defaultValue));
        } else {
            log.debug(String.format("System property <%s> is set to %s", propertyName, value));
        }
        return value;
    }

    private static class BooleanPropertyExtractor
    implements PropertyExtractor<Boolean> {
        private BooleanPropertyExtractor() {
        }

        @Override
        public Boolean extract(String propertyName) {
            String property = System.getProperty(propertyName);
            return BooleanUtils.toBoolean((String)property);
        }
    }

    private static class IntegerPropertyExtractor
    implements PropertyExtractor<Integer> {
        private IntegerPropertyExtractor() {
        }

        @Override
        public Integer extract(String propertyName) {
            return Integer.getInteger(propertyName);
        }
    }

    private static interface PropertyExtractor<T> {
        public T extract(String var1);
    }
}

