/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.midori.confluence.plugin.archiving.model.GlobalSettings;
import com.midori.confluence.plugin.archiving.model.ao.GlobalSettingsAo;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalSettingsManager_ {
    private static Logger log = LoggerFactory.getLogger(GlobalSettingsManager_.class);
    private ActiveObjects ao;
    private static Comparator<GlobalSettingsAo> SETTINGS_AO_BY_ID_ASC_COMPARATOR = new Comparator<GlobalSettingsAo>(){

        @Override
        public int compare(GlobalSettingsAo o1, GlobalSettingsAo o2) {
            return new Integer(o1.getID()).compareTo(o2.getID());
        }
    };

    public GlobalSettingsManager_(ActiveObjects ao) {
        this.ao = ao;
    }

    public GlobalSettings getGlobalSettings() {
        return (GlobalSettings)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<GlobalSettings>(){

            public GlobalSettings doInTransaction() {
                Option globalSettingsAoOption = GlobalSettingsManager_.this.findGlobalSettingsAo();
                if (globalSettingsAoOption.isEmpty()) {
                    GlobalSettings globalSettings = GlobalSettings.createDefault();
                    GlobalSettingsManager_.this.save(globalSettings);
                    return globalSettings;
                }
                return GlobalSettings.fromAo((GlobalSettingsAo)globalSettingsAoOption.get());
            }
        });
    }

    public int save(final GlobalSettings settings) {
        return (Integer)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction() {
                GlobalSettingsAo globalSettingsAo;
                Option globalSettingsAoOption = GlobalSettingsManager_.this.findGlobalSettingsAo();
                if (globalSettingsAoOption.isEmpty()) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("TRUSTED_GROUP", settings.getTrustedGroup());
                    params.put("DEFAULT_GLOBAL_CONFIG_ID", settings.getDefaultGlobalConfigurationId());
                    globalSettingsAo = (GlobalSettingsAo)GlobalSettingsManager_.this.ao.create(GlobalSettingsAo.class, params);
                } else {
                    globalSettingsAo = (GlobalSettingsAo)globalSettingsAoOption.get();
                    globalSettingsAo.setTrustedGroup(settings.getTrustedGroup());
                    globalSettingsAo.setDefaultGlobalConfigurationId(settings.getDefaultGlobalConfigurationId());
                    globalSettingsAo.save();
                }
                return globalSettingsAo.getID();
            }
        });
    }

    private Option<GlobalSettingsAo> findGlobalSettingsAo() {
        List<GlobalSettingsAo> globalSettingsAos = Arrays.asList((GlobalSettingsAo[])this.ao.find(GlobalSettingsAo.class));
        if (globalSettingsAos.isEmpty()) {
            return Option.none();
        }
        if (globalSettingsAos.size() > 1) {
            Collections.sort(globalSettingsAos, SETTINGS_AO_BY_ID_ASC_COMPARATOR);
            log.warn(String.format("%d global settings found, using the oldest one. Open a support ticket at: https://bit.ly/1HebM1v", globalSettingsAos.size()));
        }
        return Option.option((Object)globalSettingsAos.get(0));
    }
}

