/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ContentArchivingEvent;
import com.midori.confluence.plugin.archiving.model.ContentArchivingStats;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;
import com.midori.confluence.plugin.archiving.model.type.ArchivingEventType;
import com.midori.confluence.plugin.archiving.model.type.ContentArchivingStrategyType;
import com.midori.confluence.plugin.archiving.model.type.LifecycleNotificationReason;
import com.midori.confluence.plugin.archiving.model.type.NotificationEmailTemplateType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventDataProvider;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorInvalidException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorNotFoundException;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingEventManager;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionResult;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionSpecification;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.impl.CopyAndTrashArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.impl.MoveArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.impl.TrashArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.SpaceReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleNotificationHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataAnonymizer;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPageArchiving;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import com.midori.confluence.plugin.archiving.util.BooleanSettingExtractor;
import com.midori.confluence.plugin.archiving.util.CommaSeparatedStringListSettingExtractor;
import com.midori.confluence.plugin.archiving.util.GlobalFreshSpacePredicate;
import com.midori.confluence.plugin.archiving.util.SpaceByNameComparator;
import com.midori.confluence.plugin.archiving.util.limited.LimitedList;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentArchivingManager {
    private static Logger log = LoggerFactory.getLogger(ContentArchivingManager.class);
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentArchivingEventManager contentArchivingEventManager;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;
    private ContentLifecycleNotificationHelper contentLifecycleNotificationHelper;
    private ContentTraversalHelper contentTraversalHelper;
    private ContentEventDataProvider contentEventDataProvider;
    protected PageReplicator pageReplicator;
    protected SpaceHelper spaceHelper;
    protected SpaceReplicator spaceReplicator;

    public ContentArchivingManager(PageManager pageManager, SpaceManager spaceManager, ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentArchivingEventManager contentArchivingEventManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleNotificationHelper contentLifecycleNotificationHelper, ContentTraversalHelper contentTraversalHelper, ContentEventDataProvider contentEventDataProvider, PageReplicator pageReplicator, SpaceHelper spaceHelper, SpaceReplicator spaceReplicator) {
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentArchivingEventManager = contentArchivingEventManager;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
        this.contentLifecycleNotificationHelper = contentLifecycleNotificationHelper;
        this.contentTraversalHelper = contentTraversalHelper;
        this.contentEventDataProvider = contentEventDataProvider;
        this.pageReplicator = pageReplicator;
        this.spaceHelper = spaceHelper;
        this.spaceReplicator = spaceReplicator;
    }

    public Map<Page, ContentView> findNotViewedPages(Space space) {
        ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
        if (config.isPageViewTrackingByAgeEnabled()) {
            long viewAlertAge = config.getPageViewAlertAge() * 86400000L;
            Map<Page, ContentView> notViewedPages = this.findPagesViewedEarlierThan(space, viewAlertAge);
            log.debug(notViewedPages.size() + " not-viewed pages found in <" + space.getKey() + ">");
            return notViewedPages;
        }
        return Collections.emptyMap();
    }

    private Map<Page, ContentView> findPagesViewedEarlierThan(Space space, long age) {
        Set<Page> pages = this.findLifecycleTrackedPages(space);
        Map<Page, ContentView> events = this.contentEventDataProvider.findPageViewEventsOlderThan(pages, age);
        ModelUtils.removeNullValues(events);
        return events;
    }

    public int sendNotViewedPagesNotificationEmails(LimitedMap<LightSpace, LimitedMap<LightPage, ContentView>> spacesToNotViewedPages) {
        Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> reasonsToAddresseesToSpacesToPages = this.contentLifecycleNotificationHelper.findAddressees(spacesToNotViewedPages, (Function<LightPage, LightPage>)Functions.identity(), new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyAuthorOnPageView();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyLastModifierOnPageView();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyOwnersOnPageView();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceAdminsOnPageView();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceCreatorOnPageView();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySupervisorsOnPageView();
            }
        }, new CommaSeparatedStringListSettingExtractor(){

            public List<String> apply(ContentArchivingConfiguration config) {
                return this.toList(config.getSupervisorsOnPageView());
            }
        });
        int emailsSent = this.contentLifecycleNotificationHelper.sendEmails(reasonsToAddresseesToSpacesToPages, NotificationEmailTemplateType.NON_VIEWED_PAGES, (Map<String, ?>)ImmutableMap.of((Object)"spacesToNotViewedPages", DataAnonymizer.anonymizeSpaceKeyedPageKeyedMap(spacesToNotViewedPages)));
        return emailsSent;
    }

    public Map<Page, ContentUpdate> findExpiredPages(Space space) {
        ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
        if (config.isPageExpirationTrackingByAgeEnabled() || config.isPageExpirationTrackingByLabelEnabled()) {
            Map<Page, ContentUpdate> explicitlyExpiredPages;
            HashMap<Page, ContentUpdate> expiredPages = new HashMap<Page, ContentUpdate>();
            if (config.isPageExpirationTrackingByAgeEnabled()) {
                long expirationAlertAge = config.getPageExpirationAlertAge() * 86400000L;
                Map<Page, ContentUpdate> ageExpiredPages = this.findPagesUpdatedEarlierThan(space, expirationAlertAge);
                expiredPages.putAll(ageExpiredPages);
            }
            if (config.isPageExpirationTrackingByLabelEnabled() && !(explicitlyExpiredPages = this.findExpiredPagesByLabel(space)).isEmpty()) {
                expiredPages.putAll(explicitlyExpiredPages);
            }
            if (!expiredPages.isEmpty()) {
                Set<Page> nonLifecycleTrackedPages = this.findNonLifecycleTrackedPages(space);
                for (Page nonLifecycleTrackedPage : nonLifecycleTrackedPages) {
                    expiredPages.remove(nonLifecycleTrackedPage);
                }
            }
            log.debug(expiredPages.size() + " expired pages found in <" + space.getKey() + ">");
            return expiredPages;
        }
        return Collections.emptyMap();
    }

    private Map<Page, ContentUpdate> findPagesUpdatedEarlierThan(Space space, long age) {
        Set<Page> pages = this.findLifecycleTrackedPages(space);
        Map<Page, ContentUpdate> events = this.contentEventDataProvider.findPageUpdateEventsOlderThan(pages, age);
        ModelUtils.removeNullValues(events);
        return events;
    }

    Map<Page, ContentUpdate> findExpiredPagesByLabel(Space space) {
        HashMap<Page, ContentUpdate> expiredPages = new HashMap<Page, ContentUpdate>();
        SortedMap<Date, Map<Page, String>> pagesLabeledWithExpireYymmdd = this.contentTraversalHelper.findPagesLabelledWithYyymmdd(space, "expire-single-", "expire-", "expire-on-date-type labels");
        for (Date date : pagesLabeledWithExpireYymmdd.keySet()) {
            Map pagesOnDate = (Map)pagesLabeledWithExpireYymmdd.get(date);
            for (Page page : pagesOnDate.keySet()) {
                if (expiredPages.containsKey(page)) continue;
                String labelerName = (String)pagesOnDate.get(page);
                expiredPages.put(page, ContentUpdate.newMarkedAsExpired(labelerName, date));
            }
        }
        return expiredPages;
    }

    public Map<Page, ContentUpdate> findPagesToReview(Space space, Map<Page, ContentUpdate> expiredPages) {
        return this.findExpiredPagesLabeledWith(space, expiredPages, "archive-review");
    }

    public Map<Page, ContentUpdate> findPagesToUpdate(Space space, Map<Page, ContentUpdate> expiredPages) {
        return this.findExpiredPagesLabeledWith(space, expiredPages, "archive-update");
    }

    private Map<Page, ContentUpdate> findExpiredPagesLabeledWith(Space space, Map<Page, ContentUpdate> expiredPages, String labelName) {
        final Set<Page> pagesLabeled = this.contentTraversalHelper.findPagesLabeledWith(space, labelName, false);
        Map filtered = Maps.filterKeys(expiredPages, (Predicate)new Predicate<Page>(){

            public boolean apply(Page page) {
                return pagesLabeled.contains(page);
            }
        });
        return filtered;
    }

    public void createExpirationEvents(LimitedMap<LightSpace, LimitedList<Long>> spacesToExpiredPageIds) {
        for (LightSpace space : spacesToExpiredPageIds.keySet()) {
            ArrayList<ContentArchivingEvent> events = new ArrayList<ContentArchivingEvent>();
            LimitedList<Long> expiredPageIds = spacesToExpiredPageIds.get(space);
            if (!expiredPageIds.isEmpty()) {
                events.add(new ContentArchivingEvent(space.getKey(), new Date(), ArchivingEventType.EXPIRED, null, new HashSet<Long>(expiredPageIds), expiredPageIds.getRemainingCount()));
            } else {
                events.add(new ContentArchivingEvent(space.getKey(), new Date(), ArchivingEventType.EXPIRED, null, Collections.emptySet(), 0));
            }
            this.contentArchivingEventManager.createEvents(events);
        }
    }

    private SetMultimap<Pair<Date, String>, Long> findPageUpdatesSincePreviousEvent(Space space, Set<Long> expiredPageIds) {
        LinkedHashMultimap pageUpdates = LinkedHashMultimap.create();
        Option<ContentArchivingEvent> previousExpiredEventOption = this.contentArchivingEventManager.getLatestEventOfType(space, ArchivingEventType.EXPIRED);
        if (previousExpiredEventOption.isDefined()) {
            ContentArchivingEvent event = (ContentArchivingEvent)previousExpiredEventOption.get();
            Set<Long> previouslyExpiredPageIds = event.getPageIds();
            Sets.SetView updatedPageIds = Sets.difference(previouslyExpiredPageIds, expiredPageIds);
            log.debug(String.format("%d updated pages found in <%s>", updatedPageIds.size(), space.getKey()));
            if (!updatedPageIds.isEmpty()) {
                Map<Page, ContentUpdate> pagesAndLastUpdates = this.findPagesUpdatedEarlierThan(space, 0L);
                for (Long updatedPageId : updatedPageIds) {
                    Page updatedPage = this.pageManager.getPage(updatedPageId.longValue());
                    if (updatedPage == null) continue;
                    ContentUpdate contentUpdate = pagesAndLastUpdates.get(updatedPage);
                    if (contentUpdate != null) {
                        if (!contentUpdate.getUpdateDate().after(event.getDate())) continue;
                        pageUpdates.put((Object)Pair.pair((Object)contentUpdate.getUpdateDate(), (Object)StringUtils.defaultString((String)contentUpdate.getUpdaterName(), (String)"Anonymous")), (Object)updatedPage.getId());
                        log.trace(String.format("Update on <%s>: '%s'", updatedPage.getTitle(), contentUpdate.getUpdateAction()));
                        continue;
                    }
                    log.warn(String.format("Last update was not found for <%s>", updatedPage.getTitle()));
                }
            }
        }
        return pageUpdates;
    }

    public int sendExpiredPagesNotificationEmails(LimitedMap<LightSpace, LimitedMap<LightPage, ContentUpdate>> spacesToExpiredPages) {
        Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> reasonsToAddresseesToSpacesToPages = this.contentLifecycleNotificationHelper.findAddressees(spacesToExpiredPages, (Function<LightPage, LightPage>)Functions.identity(), new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyAuthorOnPageExpiration();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyLastModifierOnPageExpiration();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyOwnersOnPageExpiration();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceAdminsOnPageExpiration();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceCreatorOnPageExpiration();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySupervisorsOnPageExpiration();
            }
        }, new CommaSeparatedStringListSettingExtractor(){

            public List<String> apply(ContentArchivingConfiguration config) {
                return this.toList(config.getSupervisorsOnPageExpiration());
            }
        });
        int emailsSent = this.contentLifecycleNotificationHelper.sendEmails(reasonsToAddresseesToSpacesToPages, NotificationEmailTemplateType.EXPIRED_PAGES, (Map<String, ?>)ImmutableMap.of((Object)"spacesToExpiredPages", DataAnonymizer.anonymizeSpaceKeyedPageKeyedMap(spacesToExpiredPages)));
        return emailsSent;
    }

    public ContentArchivingExecutionContext archiveSpace(Space space, final ProgressTracker progressTracker) {
        final ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
        Map<Page, PageArchiving> freshPagesProcessed = this.findPagesToArchive(space.getKey(), config);
        Pair<Map<Page, PageArchiving>, Map<Page, PageArchiving>> split = ContentArchivingManager.splitProcessedPagesToArchivedAndSkipped(freshPagesProcessed);
        final Map freshPagesToArchive = (Map)split.left();
        Map freshPagesSkipped = (Map)split.right();
        log.debug(String.format("%d pages found to archive (%d to skip) in <%s>", freshPagesToArchive.size(), freshPagesSkipped.size(), space.getKey()));
        final ContentArchivingExecutionContext context = new ContentArchivingExecutionContext(space);
        context.addFreshPagesSkipped(freshPagesSkipped);
        if (!freshPagesToArchive.isEmpty()) {
            try {
                this.contentLifecycleActorHelper.withArchivingActor(space, new Function<Space, Void>(){

                    public Void apply(@Nullable Space spaceInternal) {
                        ContentArchivingStrategy strategy = ContentArchivingManager.this.createContentArchivingStrategy(config.getArchivingStrategyType(), progressTracker);
                        ContentArchivingExecutionSpecification specification = ContentArchivingManager.this.createContentArchivingExecutionSpecification(strategy, config, spaceInternal, freshPagesToArchive);
                        ContentArchivingManager.executeArchiving(strategy, specification, context);
                        return null;
                    }
                });
            }
            catch (ArchivingActorNotFoundException ex) {
                log.warn(String.format("Failed to find any actor for <%s>", space.getKey()));
                return context;
            }
            catch (ArchivingActorInvalidException ex) {
                log.warn(String.format("Actor <%s> selected for <%s> is not available (deleted, disabled or permissions removed), skipping archiving", ex.getActor(), space.getKey()));
                return context;
            }
            catch (ArchivingActorException ex) {
                log.warn(String.format("Failed to authenticate actor <%s> for <%s>, skipping archiving", ex.getActor(), space.getKey()));
                return context;
            }
            catch (Throwable ex) {
                log.warn(String.format("Failed to execute archiving on <%s>, skipping", space.getKey()), ex);
                return context;
            }
        }
        if (context.getFreshPagesArchived().size() != freshPagesToArchive.size()) {
            log.warn(String.format("Only %d of the %d pages were successfully archived in <%s>", context.getFreshPagesArchived().size(), freshPagesToArchive.size(), space.getKey()));
        }
        return context;
    }

    Map<Page, PageArchiving> findPagesToArchive(String spaceKey, ContentArchivingConfiguration configuration) {
        Space space = this.spaceManager.getSpace(spaceKey);
        Map<Page, ContentView> pagesToArchiveByViewAge = this.findPagesToArchiveByViewAge(space, configuration);
        Map<Page, ContentUpdate> pagesToArchiveByAge = this.findPagesToArchiveByAge(space, configuration);
        Map<Page, PageArchiving> pagesToArchive = this.combinePagesToArchive(pagesToArchiveByViewAge, pagesToArchiveByAge, configuration);
        log.debug(String.format("%d archivable pages found after combining %d by-view-age and %d by-age pages", pagesToArchiveByAge.size(), pagesToArchiveByViewAge.size(), pagesToArchiveByAge.size()));
        if (configuration.isPageArchivingByLabelEnabled()) {
            Map<Page, PageArchiving> pagesByLabel = this.findPagesToArchiveByLabel(space, configuration.isArchivingReasonRequired());
            pagesToArchive.putAll(pagesByLabel);
            log.debug(String.format("%d archivable pages found after adding %d by-label pages", pagesToArchive.size(), pagesByLabel.size()));
        }
        if (!pagesToArchive.isEmpty()) {
            Set<Page> nonLifecycleTrackedPages = this.findNonLifecycleTrackedPages(space);
            pagesToArchive.keySet().removeAll(nonLifecycleTrackedPages);
            log.debug(String.format("%d archivable pages found after removing %d non-lifecycle-tracked pages", pagesToArchive.size(), nonLifecycleTrackedPages.size()));
        }
        return pagesToArchive;
    }

    private Map<Page, ContentView> findPagesToArchiveByViewAge(Space space, ContentArchivingConfiguration configuration) {
        HashMap<Page, ContentView> notViewedPages = new HashMap<Page, ContentView>();
        if (configuration.isPageArchivingByViewAgeEnabled()) {
            long archivingViewAge = configuration.getPageArchivingViewAge() * 86400000L;
            notViewedPages.putAll(this.findPagesViewedEarlierThan(space, archivingViewAge));
        }
        return notViewedPages;
    }

    private Map<Page, ContentUpdate> findPagesToArchiveByAge(Space space, ContentArchivingConfiguration configuration) {
        HashMap<Page, ContentUpdate> notUpdatedPages = new HashMap<Page, ContentUpdate>();
        if (configuration.isPageArchivingByAgeEnabled()) {
            long archivingAge = configuration.getPageArchivingAge() * 86400000L;
            notUpdatedPages.putAll(this.findPagesUpdatedEarlierThan(space, archivingAge));
        }
        return notUpdatedPages;
    }

    private Map<Page, PageArchiving> combinePagesToArchive(Map<Page, ContentView> notViewedPages, Map<Page, ContentUpdate> expiredPages, ContentArchivingConfiguration configuration) {
        HashMap<Page, ContentView> notViewedPagesCopy = new HashMap<Page, ContentView>(notViewedPages);
        HashMap<Page, ContentUpdate> expiredPagesCopy = new HashMap<Page, ContentUpdate>(expiredPages);
        if (configuration.isPageArchivingByViewAgeEnabled() && configuration.isPageArchivingOperatorAnd() && configuration.isPageArchivingByAgeEnabled()) {
            ModelUtils.retainOnlyIntersectingKeys(notViewedPagesCopy, expiredPagesCopy);
        }
        HashMap<Page, PageArchiving> pagesToArchive = new HashMap<Page, PageArchiving>(notViewedPagesCopy.size() + expiredPagesCopy.size());
        ContentArchivingManager.putNotViewedPages(pagesToArchive, notViewedPagesCopy, configuration);
        ContentArchivingManager.putNotUpdatedPages(pagesToArchive, expiredPagesCopy, configuration);
        return pagesToArchive;
    }

    private static void putNotViewedPages(Map<Page, PageArchiving> pagesToArchive, Map<Page, ContentView> notViewedPages, ContentArchivingConfiguration configuration) {
        for (Page page : notViewedPages.keySet()) {
            pagesToArchive.put(page, ContentArchivingManager.createPageArchivingForNotViewedPage(page, configuration));
        }
    }

    private static void putNotUpdatedPages(Map<Page, PageArchiving> pagesToArchive, Map<Page, ContentUpdate> notUpdatedPages, ContentArchivingConfiguration configuration) {
        for (Page page : notUpdatedPages.keySet()) {
            pagesToArchive.put(page, ContentArchivingManager.createPageArchivingForNotUpdatedPage(page, configuration));
        }
    }

    private static PageArchiving createPageArchivingForNotViewedPage(Page page, ContentArchivingConfiguration configuration) {
        return new PageArchiving(page, String.format("not viewed for %d+ days", configuration.getPageArchivingViewAge()), null, null, false);
    }

    private static PageArchiving createPageArchivingForNotUpdatedPage(Page page, ContentArchivingConfiguration configuration) {
        return new PageArchiving(page, String.format("not updated for %d+ days", configuration.getPageArchivingAge()), null, null, false);
    }

    Map<Page, PageArchiving> findPagesToArchiveByLabel(Space space, boolean archivingReasonRequired) {
        SortedMap<Date, Map<Page, String>> pagesLabeledWithArchiveYymmddRaw = this.contentTraversalHelper.findPagesLabelledWithYyymmdd(space, "archive-single-", "archive-", "archive-on-date-type labels");
        HashMap<Page, String> pagesLabeledWithArchiveYymmdd = new HashMap<Page, String>();
        for (Date date : pagesLabeledWithArchiveYymmddRaw.keySet()) {
            Map pagesOnDate = (Map)pagesLabeledWithArchiveYymmddRaw.get(date);
            for (Page page : pagesOnDate.keySet()) {
                if (pagesLabeledWithArchiveYymmdd.containsKey(page)) continue;
                pagesLabeledWithArchiveYymmdd.put(page, (String)pagesOnDate.get(page));
            }
        }
        Map<Page, String> pagesLabeledWithArchive = this.findPagesLabeledForArchiving(space);
        HashMap<Page, PageArchiving> pagesToArchive = new HashMap<Page, PageArchiving>(pagesLabeledWithArchiveYymmdd.size() + pagesLabeledWithArchive.size());
        pagesToArchive.putAll(this.enrichArchivablePages(pagesLabeledWithArchiveYymmdd, "labeled with archive-yy/mm/dd", archivingReasonRequired));
        pagesToArchive.putAll(this.enrichArchivablePages(pagesLabeledWithArchive, "labeled with archive", archivingReasonRequired));
        return pagesToArchive;
    }

    private Map<Page, String> findPagesLabeledForArchiving(Space space) {
        LinkedHashMap<Page, String> pagesLabeledForArchiving = new LinkedHashMap<Page, String>();
        pagesLabeledForArchiving.putAll(this.contentTraversalHelper.findPagesLabeledWithAndLabelers(space, "archive", true));
        pagesLabeledForArchiving.putAll(this.contentTraversalHelper.findPagesLabeledWithAndLabelers(space, "archive-single", false));
        return pagesLabeledForArchiving;
    }

    private Map<Page, PageArchiving> enrichArchivablePages(Map<Page, String> pagesLabeledWithArchiveOrArchiveYymmdd, String archivingAction, boolean archivingReasonRequired) {
        HashMap<Page, PageArchiving> pagesToArchive = new HashMap<Page, PageArchiving>();
        for (Page page : pagesLabeledWithArchiveOrArchiveYymmdd.keySet()) {
            String reason = archivingReasonRequired ? this.contentTraversalHelper.getArchivingReason(page) : null;
            boolean skipped = archivingReasonRequired && reason == null;
            pagesToArchive.put(page, new PageArchiving(skipped ? null : page, archivingAction, pagesLabeledWithArchiveOrArchiveYymmdd.get(page), reason, skipped));
        }
        return pagesToArchive;
    }

    private static Pair<Map<Page, PageArchiving>, Map<Page, PageArchiving>> splitProcessedPagesToArchivedAndSkipped(Map<Page, PageArchiving> pagesProcessed) {
        HashMap<Page, PageArchiving> pagesArchived = new HashMap<Page, PageArchiving>();
        HashMap<Page, PageArchiving> pagesSkipped = new HashMap<Page, PageArchiving>();
        for (Map.Entry<Page, PageArchiving> entry : pagesProcessed.entrySet()) {
            if (!entry.getValue().isSkipped()) {
                pagesArchived.put(entry.getKey(), entry.getValue());
                continue;
            }
            pagesSkipped.put(entry.getKey(), entry.getValue());
        }
        return Pair.pair(pagesArchived, pagesSkipped);
    }

    private ContentArchivingExecutionSpecification createContentArchivingExecutionSpecification(ContentArchivingStrategy strategy, ContentArchivingConfiguration config, Space space, Map<Page, PageArchiving> freshPagesToArchive) {
        Map<Page, PageArchiving> sortedFreshPagesToArchive = null;
        int freshPagesToArchiveCount = freshPagesToArchive.size();
        if (strategy.requiresSortedFreshPages(freshPagesToArchiveCount)) {
            log.debug(String.format("Pre-sorting %d archivable pages for strategy %s", new Object[]{freshPagesToArchiveCount, config.getArchivingStrategyType()}));
            long start = System.currentTimeMillis();
            sortedFreshPagesToArchive = this.contentTraversalHelper.sortPageKeyedMapByPosition(space, freshPagesToArchive);
            long durationInSeconds = (System.currentTimeMillis() - start) / 1000L;
            log.debug(String.format("%d archivable pages pre-sorted for strategy %s in %ds", new Object[]{freshPagesToArchiveCount, config.getArchivingStrategyType(), durationInSeconds}));
        } else {
            sortedFreshPagesToArchive = freshPagesToArchive;
            log.debug(String.format("%d archivable pages left unsorted for strategy %s", new Object[]{freshPagesToArchiveCount, config.getArchivingStrategyType()}));
        }
        return new ContentArchivingExecutionSpecification(config, space, sortedFreshPagesToArchive);
    }

    private static void executeArchiving(ContentArchivingStrategy strategy, ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
        log.debug(String.format("Executing strategy %s in <%s> (pages: %d)", new Object[]{specification.getConfiguration().getArchivingStrategyType(), specification.getSpace().getKey(), specification.getFreshPagesToArchive().size()}));
        PluginHelper.setLoggingLevel("com.atlassian.confluence.event.MonitorableCallerRunsPolicy", Level.ERROR);
        PluginHelper.setLoggingLevel("com.atlassian.confluence.plugins.synchrony.service", Level.ERROR);
        long start = System.currentTimeMillis();
        strategy.execute(specification, context);
        long durationInSeconds = (System.currentTimeMillis() - start) / 1000L;
        log.debug(String.format("Strategy %s completed in <%s> %ds (%dm) (pages: %d, errors: %d)", new Object[]{specification.getConfiguration().getArchivingStrategyType(), specification.getSpace().getKey(), durationInSeconds, durationInSeconds / 60L, context.getFreshPagesArchived().size(), context.getErrors().size()}));
        if (log.isDebugEnabled()) {
            ContentArchivingStats stats = context.toContentArchivingStats();
            if (specification.getConfiguration().getArchivingStrategyType() == ContentArchivingStrategyType.COPY_AND_TRASH) {
                log.debug(String.format("    %d pages were copied to the archive space", stats.getPagesCreatedOrSynched()));
                log.debug(String.format("        %d pages were newly copied", stats.getPagesCreated()));
                log.debug(String.format("        %d pages were updated to the current version", stats.getPagesSynched()));
                log.debug(String.format("        %d parent pages were newly created", stats.getParentsCreated()));
                log.debug(String.format("        %d parent pages were updated to the current version", stats.getParentsSynched()));
                log.debug(String.format("    %d pages were trashed", stats.getPagesTrashed()));
            } else if (specification.getConfiguration().getArchivingStrategyType() == ContentArchivingStrategyType.MOVE) {
                log.debug(String.format("    %d pages were moved to the archive space", stats.getPagesCreatedOrSynched()));
                log.debug(String.format("        %d pages were newly moved", stats.getPagesCreated()));
                log.debug(String.format("        %d pages were moved by overwriting a previous version", stats.getPagesSynched()));
                log.debug(String.format("        %d parent pages were newly created", stats.getParentsCreated()));
                log.debug(String.format("        %d parent pages were updated to the current version", stats.getParentsSynched()));
            } else {
                log.debug(String.format("    %d pages were trashed", stats.getPagesTrashed()));
            }
            log.debug(String.format("    %d pages were skipped", stats.getPagesSkipped()));
        }
    }

    private ContentArchivingStrategy createContentArchivingStrategy(ContentArchivingStrategyType archivingStrategyType, ProgressTracker progressTracker) {
        switch (archivingStrategyType) {
            case COPY_AND_TRASH: {
                return new CopyAndTrashArchivingStrategy(this.spaceManager, this.pageManager, this.contentTraversalHelper, this.pageReplicator, this.spaceReplicator, this.spaceHelper, progressTracker);
            }
            case MOVE: {
                return new MoveArchivingStrategy(this.spaceManager, this.pageManager, this.contentTraversalHelper, this.pageReplicator, this.spaceReplicator, this.spaceHelper, progressTracker);
            }
            case TRASH: {
                return new TrashArchivingStrategy(this.spaceManager, this.pageManager, this.contentTraversalHelper, this.pageReplicator, this.spaceReplicator, progressTracker);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown archiving strategy type: %s", new Object[]{archivingStrategyType}));
    }

    public void createArchivingEvents(Set<LightSpace> spaces, LimitedMap<LightSpace, LimitedList<Long>> spacesToArchivedPageIds, LimitedMap<LightSpace, LimitedList<Long>> spacesToSkippedPageIds) {
        Date currentDate = new Date();
        for (LightSpace space : spaces) {
            LimitedList<Long> archivedPageIds = spacesToArchivedPageIds.get(space);
            LimitedList<Long> skippedPageIds = spacesToSkippedPageIds.get(space);
            if (archivedPageIds == null || skippedPageIds == null) continue;
            if (!archivedPageIds.isEmpty() || !spacesToSkippedPageIds.isEmpty()) {
                if (!archivedPageIds.isEmpty()) {
                    this.contentArchivingEventManager.createEvent(new ContentArchivingEvent(space.getKey(), currentDate, ArchivingEventType.ARCHIVED, null, new HashSet<Long>(archivedPageIds), Math.max(archivedPageIds.getRemainingCount(), 0)));
                }
                if (skippedPageIds.isEmpty()) continue;
                this.contentArchivingEventManager.createEvent(new ContentArchivingEvent(space.getKey(), currentDate, ArchivingEventType.SKIPPED, null, new HashSet<Long>(skippedPageIds), Math.max(skippedPageIds.getRemainingCount(), 0)));
                continue;
            }
            this.contentArchivingEventManager.createEvent(new ContentArchivingEvent(space.getKey(), currentDate, ArchivingEventType.ARCHIVED, null, Collections.emptySet(), 0));
        }
    }

    public ContentArchivingStats sendArchivedPagesNotificationEmails(ContentArchivingExecutionResult result, LimitedMap<LightSpace, LimitedMap<LightPage, LightPageArchiving>> pagesArchived, LimitedMap<LightSpace, LimitedMap<LightPage, LightPageArchiving>> pagesSkipped) {
        Map<LightSpace, LightSpace> archiveSpacesToFreshSpaces = result.getArchiveSpacesToFreshSpaces();
        Map<LightPage, LightPage> archivePagesToFreshPages = result.getArchivePagesToFreshPages();
        SpaceAndPageCountingStats pageArchivingStats = result.getArchivePageStatsByArchiveSpace();
        SpaceAndPageCountingStats pageSkippingStats = result.getPageSkippingStatsByFreshSpace();
        if (log.isTraceEnabled()) {
            log.trace(String.format("Archive spaces to fresh spaces map: %s", archiveSpacesToFreshSpaces));
            log.trace(String.format("Archive pages to fresh pages map: %s", archivePagesToFreshPages));
            log.trace(String.format("Page archiving stats: %s", pageArchivingStats));
            log.trace(String.format("Page skipping stats: %s", pageSkippingStats));
        }
        Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> addresseesArchived = this.contentLifecycleNotificationHelper.findAddressees(pagesArchived, new ArchivePageToFreshPageFunction(archivePagesToFreshPages), new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyAuthorOnPageArchiving();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyLastModifierOnPageArchiving();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifyOwnersOnPageArchiving();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceAdminsOnPageArchiving();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySpaceCreatorOnPageArchiving();
            }
        }, new BooleanSettingExtractor(){

            public Boolean apply(ContentArchivingConfiguration config) {
                return config.isNotifySupervisorsOnPageArchiving();
            }
        }, new CommaSeparatedStringListSettingExtractor(){

            public List<String> apply(ContentArchivingConfiguration config) {
                return this.toList(config.getSupervisorsOnPageArchiving());
            }
        });
        Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> addresseesSkipped = ContentLifecycleNotificationHelper.extractAddressees(pagesSkipped, LifecycleNotificationReason.LABELER, new Function<LightPageArchiving, String>(){

            public String apply(LightPageArchiving pageArchiving) {
                return pageArchiving.getArchiverName();
            }
        });
        int emailsSent = this.contentLifecycleNotificationHelper.sendEmails(addresseesArchived, NotificationEmailTemplateType.ARCHIVED_PAGES, (Map<String, ?>)ImmutableMap.of((Object)"pagesArchived", DataAnonymizer.anonymizeSpaceKeyedPageKeyedMap(pagesArchived)));
        ContentArchivingStats stats = result.getAggregatedContentArchivingStats();
        stats.addEmailsSent(emailsSent += this.contentLifecycleNotificationHelper.sendEmails(addresseesSkipped, NotificationEmailTemplateType.SKIPPED_PAGES, (Map<String, ?>)ImmutableMap.of((Object)"pagesSkipped", DataAnonymizer.anonymizeSpaceKeyedPageKeyedMap(pagesSkipped))));
        return stats;
    }

    public int sendDiscussedPagesNotificationEmails(LightSpace space, LightPage page, ConfluenceUser sender, String[] addressees, String message) {
        LimitedMap<LightSpace, LimitedList<LightPage>> spacesToPages = new LimitedMap<LightSpace, LimitedList<LightPage>>(new HashMap(), 1);
        spacesToPages.put(space, new LimitedList<LightPage>(Collections.singletonList(page), 1));
        final HashMap<String, LimitedMap<LightSpace, LimitedList<LightPage>>> addresseesToSpacesToPages = new HashMap<String, LimitedMap<LightSpace, LimitedList<LightPage>>>();
        for (String addressee : addressees) {
            addresseesToSpacesToPages.put(addressee, spacesToPages);
        }
        HashMap<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> reasonsToAddresseesToSpacesToPages = new HashMap<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>>(){
            {
                this.put(LifecycleNotificationReason.RECIPIENT, addresseesToSpacesToPages);
            }
        };
        int emailsSent = this.contentLifecycleNotificationHelper.sendEmails((Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>>)reasonsToAddresseesToSpacesToPages, NotificationEmailTemplateType.DISCUSSED_PAGES, (Map<String, ?>)ImmutableMap.of((Object)"sender", (Object)sender, (Object)"page", (Object)page, (Object)"message", (Object)message, (Object)"lineBreak", (Object)"\n"));
        return emailsSent;
    }

    public List<Space> findScheduledPageViewTrackedSpaces() {
        return this.findSpacesIfScheduledAndConfigurationMatches(PageViewTrackingEnabledPredicate.INSTANCE, "<%s> is not page view tracked", "%d page view tracked spaces found");
    }

    public Option<Space> findSpaceByKeyIfPageViewTracked(Space space) {
        return this.findSpaceByKeyIfConfigurationMatches(space, PageViewTrackingEnabledPredicate.INSTANCE, "<%s> is not page view tracked");
    }

    public List<Space> findScheduledPageExpirationTrackedSpaces() {
        return this.findSpacesIfScheduledAndConfigurationMatches(PageExpirationTrackingEnabledPredicate.INSTANCE, "<%s> is not page expiration tracked", "%d page expiration tracked spaces found");
    }

    public Option<Space> findSpaceByKeyIfPageExpirationTracked(Space space) {
        return this.findSpaceByKeyIfConfigurationMatches(space, PageExpirationTrackingEnabledPredicate.INSTANCE, "<%s> is not page expiration tracked");
    }

    public List<Space> findScheduledArchivingEnabledSpaces() {
        return this.findSpacesIfScheduledAndConfigurationMatches(PageArchivingEnabledPredicate.INSTANCE, "<%s> is not page archiving enabled", "%d page archiving enabled spaces found");
    }

    public Option<Space> findSpaceByKeyIfArchivingEnabled(Space space) {
        return this.findSpaceByKeyIfConfigurationMatches(space, PageArchivingEnabledPredicate.INSTANCE, "<%s> is not page archiving enabled");
    }

    private List<Space> findSpacesIfScheduledAndConfigurationMatches(Predicate<ContentArchivingConfiguration> configurationPredicate, String notMatchingLogMessage, String countLogMessage) {
        TreeSet<Space> matchingSpaces = new TreeSet<Space>(new SpaceByNameComparator());
        List<Space> spaces = this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
        for (Space space : spaces) {
            ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            if (config.isGlobalRunsEnabled() && configurationPredicate.apply((Object)config)) {
                matchingSpaces.add(space);
                continue;
            }
            log.debug(String.format(notMatchingLogMessage, space.getKey()));
        }
        log.debug(String.format(countLogMessage, matchingSpaces.size()));
        return new ArrayList<Space>(matchingSpaces);
    }

    private Option<Space> findSpaceByKeyIfConfigurationMatches(Space space, Predicate<ContentArchivingConfiguration> configurationPredicate, String notMatchingLogMessage) {
        if (space != null) {
            ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            if (GlobalFreshSpacePredicate.INSTANCE.apply(space) && configurationPredicate.apply((Object)config)) {
                return Option.some((Object)space);
            }
            log.debug(String.format(notMatchingLogMessage, space.getKey()));
        }
        return Option.none();
    }

    public List<Space> filterSpaces(List<Space> spaces, final Predicate<ContentArchivingConfiguration> predicate) {
        return new ArrayList<Space>(Collections2.filter(spaces, (Predicate)new Predicate<Space>(){

            public boolean apply(Space space) {
                ContentArchivingConfiguration config = ContentArchivingManager.this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
                return predicate.apply((Object)config);
            }
        }));
    }

    private Set<Page> findLifecycleTrackedPages(Space space) {
        HashSet<Page> pages = new HashSet<Page>(this.pageManager.getPages(space, true));
        Set<Page> nonLifecycleTrackedPages = this.findNonLifecycleTrackedPages(space);
        pages.removeAll(nonLifecycleTrackedPages);
        return pages;
    }

    private Set<Page> findNonLifecycleTrackedPages(Space space) {
        HashSet<Page> pagesMarkedForNoArchiving = new HashSet<Page>();
        pagesMarkedForNoArchiving.addAll(this.contentTraversalHelper.findPagesLabeledWith(space, "noarchive", true));
        pagesMarkedForNoArchiving.addAll(this.contentTraversalHelper.findPagesLabeledWith(space, "noarchive-single", false));
        return pagesMarkedForNoArchiving;
    }

    public static class PageArchivingEnabledPredicate
    implements Predicate<ContentArchivingConfiguration> {
        public static final PageArchivingEnabledPredicate INSTANCE = new PageArchivingEnabledPredicate();

        public boolean apply(ContentArchivingConfiguration config) {
            return config.isPageArchivingOfAnyTypeEnabled();
        }
    }

    public static class PageExpirationTrackingEnabledPredicate
    implements Predicate<ContentArchivingConfiguration> {
        public static final PageExpirationTrackingEnabledPredicate INSTANCE = new PageExpirationTrackingEnabledPredicate();

        public boolean apply(ContentArchivingConfiguration config) {
            return config.isPageExpirationTrackingOfAnyTypeEnabled();
        }
    }

    public static class PageViewTrackingEnabledPredicate
    implements Predicate<ContentArchivingConfiguration> {
        public static final PageViewTrackingEnabledPredicate INSTANCE = new PageViewTrackingEnabledPredicate();

        public boolean apply(ContentArchivingConfiguration config) {
            return config.isPageViewTrackingOfAnyTypeEnabled();
        }
    }

    private static class ArchivePageToFreshPageFunction
    implements Function<LightPage, LightPage> {
        private Map<LightPage, LightPage> archivePagesToFreshPages;

        public ArchivePageToFreshPageFunction(Map<LightPage, LightPage> archivePagesToFreshPages) {
            this.archivePagesToFreshPages = archivePagesToFreshPages;
        }

        public LightPage apply(LightPage archivePage) {
            if (!this.archivePagesToFreshPages.containsKey(archivePage)) {
                throw new IllegalArgumentException(String.format("Failed to find archive page <%s> in the mapping", archivePage));
            }
            return this.archivePagesToFreshPages.get(archivePage);
        }
    }
}

