/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.midori.confluence.plugin.archiving.model.base.AbstractContentLifecycleStats;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;

public class ContentExpirationStats
extends AbstractContentLifecycleStats
implements SpaceAndPageCountingStats {
    private Multiset<String> spaceKeyToExpiredPageCount = HashMultiset.create();

    public void addExpiredPagesForSpace(String spaceKey, int expiredPages) {
        this.spaceKeyToExpiredPageCount.add((Object)spaceKey, expiredPages);
    }

    public int getExpiredPagesBySpace(String spaceKey) {
        return this.spaceKeyToExpiredPageCount.count((Object)spaceKey);
    }

    public int getExpiredPages() {
        return this.spaceKeyToExpiredPageCount.size();
    }

    @Override
    public int getSpaceCount() {
        return this.spaceKeyToExpiredPageCount.elementSet().size();
    }

    @Override
    public int getPageCount() {
        return this.getExpiredPages();
    }

    @Override
    public int getPageCountBySpace(String spaceKey) {
        return this.getExpiredPagesBySpace(spaceKey);
    }
}

