/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageUpdateTrigger;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.midori.confluence.plugin.archiving.model.type.PageUpdateEventType;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventIndexer;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentUpdateTracker;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.GlobalSettingsManager_;
import com.midori.confluence.plugin.archiving.util.ContentInGlobalFreshSpacePredicate;
import com.midori.confluence.plugin.archiving.util.GlobalFreshSpacePredicate;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.ReflectionUtils;

public class ContentEventListener
implements DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(ContentEventListener.class);
    private static final Set<String> BLACKLISTED_TRIGGER_TYPES = Collections.singleton("LINK_REFACTORING");
    private EventPublisher eventPublisher;
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentEventIndexer contentEventIndexer;
    private ContentUpdateTracker contentUpdateTracker;
    private GlobalSettingsManager_ globalSettingsManager;
    private static final boolean isPageCreateEventTriggerVerifiable = ContentEventListener.isTriggerTypeVerifiable(PageCreateEvent.class);

    public ContentEventListener(EventPublisher eventPublisher, ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentEventIndexer contentEventIndexer, ContentUpdateTracker contentUpdateTracker, GlobalSettingsManager_ globalSettingsManager) {
        this.eventPublisher = eventPublisher;
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentEventIndexer = contentEventIndexer;
        this.contentUpdateTracker = contentUpdateTracker;
        this.globalSettingsManager = globalSettingsManager;
        eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSpaceCreate(SpaceCreateEvent event) {
        ContentEventListener.logEvent((Event)event);
        if (ContentEventListener.isSpaceEventTrackable((SpaceEvent)event)) {
            Space space = event.getSpace();
            this.contentEventIndexer.saveIndexBuild(space);
            Integer defaultGlobalConfigurationId = this.globalSettingsManager.getGlobalSettings().getDefaultGlobalConfigurationId();
            if (defaultGlobalConfigurationId != null) {
                this.contentArchivingConfigurationManager.applyGlobalConfigurationToSpaces(defaultGlobalConfigurationId, Collections.singletonList(space.getKey()));
            }
        }
    }

    @EventListener
    public void onPageCreate(PageCreateEvent event) {
        ContentEventListener.logEvent((Event)event);
        if (ContentEventListener.isContentEventTrackable((ContentEvent)event)) {
            this.contentUpdateTracker.onContentEvent(ContentEventListener.getCurrentUserName(), (ContentEntityObject)event.getPage(), PageUpdateEventType.EDITED);
        }
    }

    @EventListener
    public void onPageUpdate(PageUpdateEvent event) {
        ContentEventListener.logEvent((Event)event);
        if (ContentEventListener.isContentEventTrackable((ContentEvent)event)) {
            this.contentUpdateTracker.onContentEvent(ContentEventListener.getCurrentUserName(), (ContentEntityObject)event.getPage(), PageUpdateEventType.EDITED);
        }
    }

    @EventListener
    public void onPageCopy(PageEvent event) {
        if (event.getClass().getSimpleName().equals("PageCopyEvent")) {
            ContentEventListener.logEvent((Event)event);
            if (ContentEventListener.isContentEventTrackable((ContentEvent)event)) {
                this.contentUpdateTracker.onContentEvent(ContentEventListener.getCurrentUserName(), (ContentEntityObject)event.getPage(), PageUpdateEventType.EDITED);
            }
        }
    }

    @EventListener
    public void onPageView(PageViewEvent event) {
    }

    @EventListener
    public void onAttachmentCreate(AttachmentCreateEvent event) {
        ContentEventListener.logEvent((Event)event);
        if (ContentEventListener.isContentEventTrackable((ContentEvent)event)) {
            this.contentUpdateTracker.onContentEvent(ContentEventListener.getCurrentUserName(), ContentEventListener.getAttachedTo((AttachmentEvent)event), PageUpdateEventType.ATTACHMENT_ADDED);
        }
    }

    @EventListener
    public void onAttachmentUpdate(AttachmentUpdateEvent event) {
        ContentEventListener.logEvent((Event)event);
        if (ContentEventListener.isContentEventTrackable((ContentEvent)event)) {
            this.contentUpdateTracker.onContentEvent(ContentEventListener.getCurrentUserName(), ContentEventListener.getAttachedTo((AttachmentEvent)event), PageUpdateEventType.ATTACHMENT_ADDED);
        }
    }

    public static boolean isRequestViewTrackable(HttpServletRequest request) {
        return request != null && request.getParameter("ap_novt") == null;
    }

    private static void logEvent(Event event) {
        if (event instanceof PageEvent) {
            logger.trace(String.format("Page event %s triggered (on %s)", event, ((PageEvent)event).getPage()));
        } else {
            logger.trace(String.format("Non-page event %s triggered", event));
        }
    }

    private static boolean isSpaceEventTrackable(SpaceEvent event) {
        Space space = event.getSpace();
        return space != null && GlobalFreshSpacePredicate.INSTANCE.apply(space);
    }

    private static boolean isContentEventTrackable(ContentEvent event) {
        ContentEntityObject attachedTo;
        if (event instanceof PageEvent) {
            boolean blacklisted = ContentEventListener.isTriggerTypeBlacklisted(event);
            if (blacklisted) {
                logger.trace(String.format("Event with blacklisted trigger type ignored: %s", event));
                return false;
            }
            Page page = ((PageEvent)event).getPage();
            return ContentInGlobalFreshSpacePredicate.INSTANCE.apply((SpaceContentEntityObject)page);
        }
        if (event instanceof AttachmentEvent && (attachedTo = ContentEventListener.getAttachedTo((AttachmentEvent)event)) instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject page = (SpaceContentEntityObject)attachedTo;
            return ContentInGlobalFreshSpacePredicate.INSTANCE.apply(page);
        }
        return false;
    }

    private static boolean isTriggerTypeVerifiable(Class<? extends PageEvent> eventClass) {
        return ReflectionUtils.findMethod(eventClass, (String)"getUpdateTrigger") != null;
    }

    private static boolean isTriggerTypeBlacklisted(ContentEvent event) {
        boolean isCreateEvent = event instanceof PageCreateEvent;
        boolean isUpdateEvent = event instanceof PageUpdateEvent;
        if (!isCreateEvent && !isUpdateEvent) {
            return false;
        }
        if (isCreateEvent && !isPageCreateEventTriggerVerifiable) {
            return false;
        }
        PageUpdateTrigger trigger = isCreateEvent ? ((PageCreateEvent)event).getUpdateTrigger() : ((PageUpdateEvent)event).getUpdateTrigger();
        return BLACKLISTED_TRIGGER_TYPES.contains(trigger.toString());
    }

    private static String getCurrentUserName() {
        return AuthenticatedUserThreadLocal.getUsername();
    }

    private static ContentEntityObject getAttachedTo(AttachmentEvent event) {
        return event.getContent();
    }
}

