/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PreviewPagesServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PreviewPagesServlet.class);
    @ConfluenceImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    @ComponentImport
    private final TemplateRenderer renderer;

    @Inject
    public PreviewPagesServlet(PageBuilderService pageBuilderService, ApplicationProperties applicationProperties, TemplateRenderer renderer) {
        this.pageBuilderService = pageBuilderService;
        this.applicationProperties = applicationProperties;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) {
        this.pageBuilderService.assembler().resources().requireWebResource("com.methoda.plugins.pagePreview4Conf:page-preview-resources");
        try {
            String issueKey = req.getParameter("issueKey");
            String pageId = req.getParameter("pageId");
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            System.out.println("pageId " + pageId);
            String templatePath = pageId == null || pageId.equals("0") && user == null ? "templates/c4j-login.vm" : (pageId.equals("0") && user != null ? "templates/create-page.vm" : "templates/preview-pages.vm");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("issueKey", issueKey);
            parameters.put("pageId", pageId);
            parameters.put("destination", "/plugins/servlet/previewpagesservlet?issueKey=" + issueKey + "&pageId=0");
            response.addHeader("issueKey", issueKey);
            response.addHeader("pageId", pageId);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(templatePath, parameters, (Writer)response.getWriter());
        }
        catch (Exception e) {
            log.error("error trying to open preview pages servlet: ", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.applicationProperties.getBaseUrl() + "/plugins/servlet/pagePreview/login?destination=" + this.getUri(request).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

