/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginCookieFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LoginCookieFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            CookieResponseWrapper wrapper = new CookieResponseWrapper((HttpServletResponse)response);
            chain.doFilter(request, (ServletResponse)wrapper);
        } else {
            chain.doFilter(request, response);
        }
    }

    private static class CookieResponseWrapper
    extends HttpServletResponseWrapper {
        public CookieResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void addHeader(String name, String value) {
            if ("Set-Cookie".equalsIgnoreCase(name) && value.contains("HttpOnly")) {
                value = value.replace("HttpOnly", "SameSite=None; Secure");
            }
            super.addHeader(name, value);
        }
    }
}

