/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.methoda.plugins.pagePreview.exception.UnauthorizedException;
import com.methoda.plugins.pagePreview.rest.ConfigResourceModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendRest {
    private static final Logger log = LoggerFactory.getLogger(SendRest.class);
    private static final String unauthorizedString = "C4J Unauthorized";

    public static String sendToJira(Request.MethodType method, String url, ApplicationLinkService applicationLinkService) throws UnauthorizedException {
        ApplicationLink applicationLink = applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
        ApplicationLinkRequestFactory applicationLinkRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        String[] result = new String[1];
        try {
            ((ApplicationLinkRequest)applicationLinkRequestFactory.createRequest(method, url).addHeader("Content-Type", "application/json")).execute(response -> {
                if (response.getStatusCode() != 200) {
                    if (response.getStatusCode() == 401) {
                        throw new ResponseException(unauthorizedString);
                    }
                    throw new ResponseException(response.getResponseBodyAsString());
                }
                result[0] = response.getResponseBodyAsString();
            });
        }
        catch (CredentialsRequiredException | ResponseException e) {
            if (e.getMessage().equals(unauthorizedString) || e.getClass().equals(CredentialsRequiredException.class)) {
                throw new UnauthorizedException(applicationLinkRequestFactory.getAuthorisationURI().toString());
            }
            log.error("error getting response from rest call to " + url, e);
        }
        return result[0];
    }

    public static ConfigResourceModel getNoAuth(String url1) throws IOException {
        URL url = new URL(url1);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("X-Atlassian-Token", "nocheck");
        InputStream responseStream = connection.getInputStream();
        ObjectMapper mapper = new ObjectMapper();
        return (ConfigResourceModel)mapper.readValue(responseStream, ConfigResourceModel.class);
    }

    public static String sendPost(Request.MethodType method, String url, String body, ApplicationLinkService applicationLinkService) throws UnauthorizedException {
        ApplicationLink applicationLink = applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
        ApplicationLinkRequestFactory applicationLinkRequestFactory = applicationLink.createAuthenticatedRequestFactory();
        String[] result = new String[1];
        try {
            ((ApplicationLinkRequest)((ApplicationLinkRequest)applicationLinkRequestFactory.createRequest(method, url).addHeader("Content-Type", "application/json")).setRequestBody(body)).execute(response -> {
                if (response.getStatusCode() != 200) {
                    if (response.getStatusCode() == 401) {
                        throw new ResponseException(unauthorizedString);
                    }
                    throw new ResponseException(response.getResponseBodyAsString());
                }
                result[0] = response.getResponseBodyAsString();
            });
        }
        catch (CredentialsRequiredException | ResponseException e) {
            if (e.getMessage().equals(unauthorizedString) || e.getClass().equals(CredentialsRequiredException.class)) {
                throw new UnauthorizedException(applicationLinkRequestFactory.getAuthorisationURI().toString());
            }
            log.error("error getting response from rest call to " + url, e);
        }
        return result[0];
    }
}

