/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.listener;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.net.Request;
import com.methoda.plugins.pagePreview.rest.SendRest;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.DisposableBean;

@Named
public class pageEventListener
implements DisposableBean {
    @ConfluenceImport
    protected EventPublisher eventPublisher;
    private final ApplicationLinkService applicationLinkService;
    @ConfluenceImport
    private final HostApplication hostApplication;
    private static final Logger log = Logger.getLogger(pageEventListener.class);

    @Inject
    public pageEventListener(EventPublisher eventPublisher, ApplicationLinkService applicationLinkService, HostApplication hostApplication) {
        this.eventPublisher = eventPublisher;
        this.applicationLinkService = applicationLinkService;
        this.hostApplication = hostApplication;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent event) {
        Page page = event.getPage();
        this.validatePanelsLinks(page);
    }

    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent event) {
        Page page = event.getPage();
        this.validatePanelsLinks(page);
    }

    public void validatePanelsLinks(Page page) {
        String pageId = page.getIdAsString();
        Document doc = Jsoup.parse((String)page.getBodyAsString());
        Elements panels = doc.getElementsByAttributeValue("ac:name", "c4j_macro");
        panels.forEach(panel -> {
            Element param = panel.getElementsByAttributeValue("ac:name", "issue-key").first();
            String issueKey = param.text();
            if (issueKey.isEmpty()) {
                return;
            }
            if (!this.pageHasWikiLink(pageId, issueKey)) {
                this.createRemoteLink(page, issueKey);
            }
        });
    }

    public void createRemoteLink(Page page, String issueKey) {
        String pageTitle = page.getTitle();
        pageTitle = pageTitle.replaceAll(" ", "%20");
        String pageId = page.getIdAsString();
        String baseUrl = this.hostApplication.getBaseUrl().toString();
        String appId = this.hostApplication.getId().toString();
        String restUrl = "/rest/api/2/issue/" + issueKey + "/remotelink";
        String body = "{\"application\": { \"type\": \"com.atlassian.confluence\" },\"globalId\": \"appId=" + appId + "&pageId=" + pageId + "\",\"relationship\": \"mentioned in\",\"object\": {\"title\": \"" + pageTitle + "\",\"url\": \"" + baseUrl + "/wiki/pages/viewpage.action?pageId=" + pageId + "\"}}";
        try {
            SendRest.sendPost(Request.MethodType.POST, restUrl, body, this.applicationLinkService);
            this.updatePageIntegrity(issueKey, page);
        }
        catch (Exception e) {
            log.error((Object)("cannot create remote link " + e));
        }
    }

    public void updatePageIntegrity(String issueKey, Page page) {
        try {
            String baseUrl = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class).getRpcUrl().toString();
            String pageIntegrityUrl = baseUrl + "/rest/pagesresource/1.0/integrity/linkedPageVersion?issueKey=" + issueKey + "&pageId=" + page.getIdAsString() + "&version=" + page.getVersion();
            SendRest.sendPost(Request.MethodType.PUT, pageIntegrityUrl, "", this.applicationLinkService);
        }
        catch (Exception e) {
            log.error((Object)("cannot update page integrity " + e));
        }
    }

    public boolean pageHasWikiLink(String pageId, String issueKey) {
        try {
            String restUrl = "/rest/api/2/issue/" + issueKey + "/remotelink";
            String resp = SendRest.sendToJira(Request.MethodType.GET, restUrl, this.applicationLinkService);
            JSONArray links = new JSONArray(resp);
            for (int i = 0; i < links.length(); ++i) {
                String str;
                JSONObject object;
                String url;
                String linkPageId;
                JSONObject jsonObj = (JSONObject)links.get(i);
                String relationship = jsonObj.getString("relationship");
                if (!relationship.equals("mentioned in") && !relationship.equals("Wiki Page") || !pageId.equals(linkPageId = (url = (object = jsonObj.getJSONObject("object")).getString("url")).substring(url.indexOf(str = "?pageId=") + str.length()))) continue;
                return true;
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

