var configuration, issueKey, pageId, linkedPages, removeCreateIssueButton = false, numOfPageChanged, displayPin = false, jira_url, editPage = false;

AJS.toInit($ => {
    initialization($)
})

async function initialization($) {
    issueKey = document.head.querySelector("[name~=issue-key][content]").content;
    pageId = document.head.querySelector("[name~=page-id][content]").content;
    document.body.innerHTML = $("#confluence-page-preview-body").html();

    configuration = await restCallGet(AJS.Confluence.getBaseUrl() +
        "/rest/pagesinissueresource/1.0/resource/configuration");

    const iframeDiv = $("#page-preview-div");
    if (configuration) {
        if (configuration.defaultSize) {
            iframeDiv.css("height", (configuration.defaultSize - 60) + "px");
        }
        if (configuration.displayPin && configuration.displayPin === "true") {
            $("#toggle-panel-page").css("display", "block");
            displayPin = true;
        }else{
            $("#toggle-panel-page").remove();
        }
        if (configuration.removeCreateIssueButton && configuration.removeCreateIssueButton === "true") {
            removeCreateIssueButton = true;
        }
    }

    iframeDiv.on("load", iframeLoaded);

    $("#select-page").on("change", selectPage);

    $("#pin-img").attr("src", AJS.Confluence.getBaseUrl() + "/s/_/_/_/download/resources/com.methoda.plugins.pagePreview4Conf:page-preview-resources/images/thumbtackIcon.png")

    iframeDiv.attr("src", pageId ?
        AJS.params.baseUrl + "/pages/viewpage.action?pageId=" + pageId + "&issueKey=" + issueKey + "&init=true" : null);

    window.addEventListener("message", receiveChildMessage, false);
}

async function initializeSelect() {
    if (!linkedPages.errorMessages) {
        $("#select-page").select2({
            placeholder: "Select a page",
            data: linkedPages
        });
        if (linkedPages.length > 0)
            changePage(1);

    } else if (linkedPages.errorMessages[0] === "Issue Does Not Exist") {
        AJS.flag({
            type: 'error',
            body: "This Jira instance is not the primary instance that is connected to Confluence, please ask your administrator to change it in the Application Links page.",
            close: 'auto'
        });
    }
}

function selectPage(flag) {
    const selectA = $("#s2id_select-page>a");
    selectA.removeClass("page-updated");
    selectA.css("background", "none");
    const selectedPage = $('#select-page').select2('data');
    const selectedPageId = selectedPage ? selectedPage.id : null;

    if (!flag) $("#toggle-panel-page").addClass("pin-button-pressed");

    const pagePreviewDiv = $("#page-preview-div");

    const currentUrlStr = pagePreviewDiv.attr("src");
    const currentUrl = currentUrlStr ? new URL(currentUrlStr) : null;
    const currentPageId = currentUrl ? currentUrl.searchParams.get('pageId') : null;

    if((currentPageId && selectedPageId && selectedPageId.toString()!== currentPageId) || flag === true) { // MAD-1694
        if (checkCompatibility())
            pagePreviewDiv.css("display", "none");

        pagePreviewDiv.attr("src", selectedPage ?
            AJS.params.baseUrl + "/pages/viewpage.action?pageId=" + selectedPage.id + "&issueKey=" + issueKey : null);
    }

    let type = "";
    if (linkedPages[0].id === selectedPageId) {
        type += "first"
    }
    if (linkedPages[linkedPages.length - 1].id === selectedPageId) {
        type += "last"
    }
    configureButtons("change-page", type);
}

function changePage(num) {
    const selectPageElement = $('#select-page');
    const currentPage = selectPageElement.select2('data');
    if (!currentPage) {
        selectPageElement.val(linkedPages[num === 1 ? 0 : linkedPages.length - 1].id).trigger('change');
    } else {
        for (let i = 0; i < linkedPages.length; i++) {
            if (linkedPages[i].id === currentPage.id) {
                selectPageElement.val(linkedPages[i + num].id).trigger('change');
                break;
            }
        }
    }
    selectPage();
}

function iframeLoaded() {
    console.log("iframeLoaded");

    setTimeout(function () {
        const page = getIframeWindow();
        if (!page)
            return;

        page.postMessage({
            data: {
                key: issueKey,
                removeCreateIssueButton: removeCreateIssueButton,
                panelOrPage: displayPin //$("#toggle-panel-page").hasClass("pin-button-pressed")
            },
            type: "iframe scroll"
        }, window.origin);

        sendConfig(page, configuration);

        changeIssue(1);

        close_jira_loader();
    }, 500);
}
function close_jira_loader() {
    //notify Jira side about iframe load
    AJS.$.ajax({
        url: AJS.Confluence.getBaseUrl() + "/rest/pagesinissueresource/1.0/resource/remoteUrl",
        type: 'GET',
        async: true,
        success: function (url) {
            jira_url = url;
            window.parent.postMessage({data: 1, type: "iframe loaded"}, url);
        },
        error: function (err) {
           console.log("Failed to retrieve Jira url "+JSON.stringify(err));
        }
    })
}

function changeIssue(num) {
    const page = getIframeWindow();
    if (!page)
        return;
    page.postMessage({data: {changeIssue: num, issueKey: issueKey}, type: "scroll issue"}, window.origin);
}

function sendConfig(page, config) {
    page.postMessage({data: config, type: "configuration"}, window.origin);
}

function getIframeWindow() {
    const iframe = $("#page-preview-div")[0];
    return iframe ? iframe.contentWindow : null;
}

async function restCallGet(url) {
    return new Promise((resolve, reject) =>
        AJS.$.ajax({
            url: url,
            type: 'get',
            dataType: 'json',
            async: true,
            success: function (data) {
                resolve(data);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                console.log("xhr", xhr);
                if (xhr.status === 401) {
                    console.log("in if")
                    AppLinks.authenticateRemoteCredentials(xhr.responseText, async function () {
                        resolve(await restCallGet(url));
                    }, function () {
                    })
                    return
                }
                AJS.flag({
                    type: 'error',
                    body: "An error occurred, please try again.",
                    close: 'auto'
                });
                console.log("error", thrownError)
            }
        })
    )
}

function configureButtons(issueOrPage, type) {
    const prev = $("#navigate>button.float-left." + issueOrPage);
    const next = $("#navigate>button.float-right." + issueOrPage);
    prev.removeAttr("disabled");
    next.removeAttr("disabled");

    if (type.includes("first")) {
        prev.attr("disabled", "disabled")
    }
    if (type.includes("last")) {
        next.attr("disabled", "disabled")
    }
}

function togglePanelPage() {
    $("#toggle-panel-page").toggleClass("pin-button-pressed");
    displayPin = !displayPin;
    selectPage(true);
}

function goToPage() {
    window.open($("#page-preview-div").attr("src"), "_blank")
}

function receiveChildMessage(event) {
    // Do we trust the sender of this message?
    if (event.origin !== window.origin)
        return;
    const message = event.data;
    if (message) {
        if (message.type) {
            switch (message.type) {
                case "show iframe":
                    if (checkCompatibility())
                        $("#page-preview-div").css("display", "block");

                    if (message.data != null) {
                        const pinButton = $("#toggle-panel-page");
                        if(pinButton.length > 0){
                            $("#navigate>.change-issue").attr("disabled",
                                message.data > 0 && pinButton.hasClass("pin-button-pressed") ? "disabled" : null);
                            pinButton.attr("disabled", message.data > 0 ? null : "disabled");
                            if (message.data <= 0) pinButton.removeClass("pin-button-pressed");
                        }
                    }

                    if(editPage === true) {
                        window.parent.postMessage({data: {issueKey:issueKey, pageId:pageId}, type: "update_page_integrity"}, jira_url);
                        editPage = false;
                    }
                    break
                case "linked pages":
                    linkedPages = message.data;
                    initializeSelect();
                    break
                case "license missing":
                    $("#license-missing").show();
                    $("navigate").hide();
                    break
                case "page updated":
                    numOfPageChanged = message.data.numOfPageChanged;
                    if (numOfPageChanged > 0) {
                        $("#navigate").css("background", configuration.updatedPageColor)
                            .css("border", "2px solid " + configuration.updatedPageColor);
                    }
                    if (message.data.currentPageChanged) {
                        const color = configuration.updatedPageColor + " !important"
                        $("#s2id_select-page>a").addClass("page-updated")
                            .css({"cssText": "background: " + color});
                    }
                    break;
                case "acknowledge page updated":
                    numOfPageChanged--;
                    if (numOfPageChanged === 0) {
                        $("#navigate").css("background", "none")
                            .css("border", "none");
                    }
                    $("#s2id_select-page>a").removeClass("page-updated")
                        .css("background", "");
                    break;
                case "edit_page":
                    if(jira_url) {
                        $("#page-preview-div")[0].style.height = "668px";
                        window.parent.postMessage({data: 1, type: "set_edit_size"}, jira_url);
                    }
                    editPage = true;
                    break;
             }
        }
    }
}

function checkCompatibility() {
    const compatibleBrowsers = ["Chrome", "OP", "Edge"];

    for (const browser of compatibleBrowsers) {
        if (navigator.userAgent.indexOf(browser) !== -1)
            return true;
    }
    return false;
}