/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.rest;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.Request;
import com.google.gson.Gson;
import com.methoda.plugins.pagePreview.exception.UnauthorizedException;
import com.methoda.plugins.pagePreview.rest.PagesInIssueResourceModel;
import com.methoda.plugins.pagePreview.rest.RemoteLink;
import com.methoda.plugins.pagePreview.rest.SendRest;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/resource")
public class PagesInIssueResource {
    private static final Logger log = LoggerFactory.getLogger(PagesInIssueResource.class);
    private final ApplicationLinkService applicationLinkService;
    private final PageManager pageManager;

    @Inject
    public PagesInIssueResource(@ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport PageManager pageManager) {
        this.pageManager = pageManager;
        this.applicationLinkService = applicationLinkService;
    }

    @GET
    @Path(value="/linkedPages")
    @Produces(value={"application/json"})
    public Response getPagesForIssue(@QueryParam(value="issueKey") String issueKey) {
        try {
            return Response.ok(Arrays.stream(new Gson().fromJson(SendRest.sendToJira(Request.MethodType.GET, "/rest/api/2/issue/" + issueKey + "/remotelink", this.applicationLinkService), RemoteLink[].class)).filter(it -> it.application != null && it.application.type != null && it.application.type.equals("com.atlassian.confluence") && it.relationship != null && (it.relationship.equals("mentioned in") || it.relationship.equals("Wiki Page"))).limit(50L).map(link -> this.createModelByUrl(link.globalId)).collect(Collectors.toList())).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)401).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            log.warn("can't get pages for issue " + issueKey, (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @GET
    @AnonymousAllowed
    @Path(value="/configuration")
    @Produces(value={"application/json"})
    public Response getJiraConfiguration() {
        try {
            String baseUrl = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class).getRpcUrl().toString();
            return Response.ok((Object)SendRest.getNoAuth(baseUrl + "/rest/c4j/configuration/1.0/config")).build();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("Can't get configuration from Jira ", (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/license")
    @Produces(value={"application/json"})
    public Response getJiraLicense() {
        try {
            return Response.ok((Object)SendRest.sendToJira(Request.MethodType.GET, "/rest/pagesresource/1.0/resource/license", this.applicationLinkService)).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)401).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("Can't get license from Jira ", (Throwable)e);
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/health")
    @AnonymousAllowed
    @Produces(value={"application/json"})
    public Response health() {
        return Response.ok((Object)"ok").build();
    }

    @GET
    @Path(value="/remoteUrl")
    @AnonymousAllowed
    public Response getJiraURL() {
        try {
            String baseUrl = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class).getRpcUrl().toString();
            return Response.ok((Object)baseUrl).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.ok((Object)e.getMessage()).build();
        }
    }

    private PagesInIssueResourceModel createModelByUrl(String url) {
        Long pageId = Long.valueOf(url.substring(url.indexOf("pageId=") + 7));
        return new PagesInIssueResourceModel(pageId, this.findTitleById(pageId), url);
    }

    private String findTitleById(Long pageId) {
        ContentEntityObject page = this.pageManager.getById(pageId.longValue());
        return page != null ? page.getTitle() : "";
    }
}

