let config;
AJS.toInit(function ($) {
    console.log("in c4j", window.name);
    const urlParams = new URLSearchParams(window.location.search);

    if (urlParams.has("issueKey")) {
        setTimeout(function () {
            scrollIssueIntoView(1, urlParams.get("issueKey"), true);
        }, 1000)
    }

    if (window.name !== 'page-preview-methoda') return;

    if (window.location.href.includes("login.action")) {
        const rememberMe = document.getElementById("os_cookie");
        if (rememberMe) {
            rememberMe.checked = true;
            rememberMe.parentElement.hidden = true;
        }
        return;
    }

    if (urlParams.has("init")) {
        initializeSelect(urlParams.get("issueKey"));
    }

    removePageMenu();
    showOnlyPageContent();
    insertBase();
    disableShortcuts();
    handleEditActions();

    window.addEventListener("message", receiveMessage, false);
});

function handleEditActions(){
    document.getElementById('editPageLink')?.parentElement.addEventListener('click', function(){
        // Update C4j section size.
        window.parent.postMessage({data: 1, type: "edit_page"}, window.origin);

        // Replace close button in order to avoid new tab issues
        let cancelBtn = document.getElementById('rte-button-cancel');
        let newCancelBtn = document.createElement("button");
        newCancelBtn.classList.add("aui-button");
        newCancelBtn.innerHTML = "Close";
        cancelBtn.parentNode.replaceChild(newCancelBtn, cancelBtn);
        newCancelBtn.addEventListener('click', function(e){
            e.preventDefault();
            window.history.go(-1);
        }, false)

        // Remove 3 dots button
        let moreBtn = document.getElementById('rte-button-ellipsis');
        if(moreBtn)
            moreBtn.remove();

    }, false)
}

async function initializeSelect(issueKey) {
    const license = await restCallPagePreview('get', AJS.Confluence.getBaseUrl() +
        "/rest/pagesinissueresource/1.0/resource/license");

    if (license.data !== "0") {
        window.parent.postMessage({data: 1, type: "license missing"},
            window.origin);
        return;
    }

    linkedPages = await restCallPagePreview('get', AJS.Confluence.getBaseUrl() +
        "/rest/pagesinissueresource/1.0/resource/linkedPages?issueKey=" +
        issueKey);

    window.parent.postMessage({data: linkedPages, type: "linked pages"},
        window.origin);
}

function removePageMenu(){
    $("#page-favourite").remove();
    $("#watch-content-button").remove();
    $("#shareContentLink").remove();
    $("#action-menu-link").remove();
    $("#action-menu").remove();
}

function removeEditButton(){
    $("#editPageLink").remove();
}

function showOnlyPageContent() {
    $('head').append('<style type="text/css" id="methoda-hide-headers">' +
        '#header {' +
        '  visibility: hidden !important;' +
        '  position: absolute !important;' +
        '  height: 0 !important;' +
        '}' +
        '' +
        '#header-precursor,' +
        '#footer,' +
        '.ia-splitter-left,' +
        '#splitter-sidebar,' +
        '#splitter > .vsplitbar {' +
        '  display: none !important;' +
        '}' +
        '' +
        // it is set from JS via style attribute, we override it here
        '#page .ia-splitter #main {' +
        '  margin-left: 0 !important;' +
        '}' +
        '' +
        '#main {' +
        '  border: none !important;' +
        '}' +
        '' +
        '#full-height-container, body {' +
        '  background-color: white !important;' +
        '}' +
        '' +
        '#splitter {' +
        '  height: 100% !important;' +
        '}' +
        '' +
        '#splitter-content {' +
        '  left: 0 !important;' +
        '  width: 100% !important;' +
        '  height: 100% !important;' +
        '}' +
        '#likes-and-labels-container,' +
        ' #comments-section,' +
        ' #main-header-placeholder,' +
        ' #page-metadata-banner,' +
        ' #breadcrumb-section {' +
        '  display: none !important;' +
        '}' +
        // '#main-header {' +
        // '  visibility: hidden !important;' +
        // '}' +
        '#title-text {' +
        '  visibility: visible !important;' +
        '}' +
        // Do not display top-level banners
        'body > div.aui-message {' +
        '  display: none' +
        '}' +
        '' +
        '/* Let\'s get this party started */' +
        '::-webkit-scrollbar {' +
        '    width: 5px;' +
        '}' +
        '' +
        '/* Track */' +
        '::-webkit-scrollbar-track {' +
        '    -webkit-border-radius: 5px;' +
        '    border-radius: 5px;' +
        '    background-color: #f1f1f1;' +
        '}' +
        '' +
        '/* Handle */' +
        '::-webkit-scrollbar-thumb {' +
        '    -webkit-border-radius: 5px;' +
        '    border-radius: 5px;' +
        '    background: rgba(179, 177, 177, 0.8);' +
        '}' +
        '' +
        '::-webkit-scrollbar-thumb:window-inactive {' +
        '    background: rgba(179, 177, 177, 0.8);' +
        '}' +
        '</style>');
}

function insertBase() {
    const oldBase = $('base');
    let href = null;
    if (oldBase.length) {
        href = oldBase.attr('href');
        oldBase.remove();
    }
    const head = $('head');
    if (!head.length) {
        return false;
    }

    const newBase = $('<base>');
    newBase.attr('target', '_blank');
    if (href) newBase.attr('href', href);
    head.prepend(newBase);
    return true;
}

function disableShortcuts() {
    $(document).on('keypress', function (e) {
        const disallowedShortcuts = [
            101, //e
            99, //c
            103, //g
            109, //m
            119, //w
            115, //s
            107, //k
            108, //l
            116, //t
            102, //f
        ];
        if (disallowedShortcuts.includes(e.keyCode)) {
            e.stopImmediatePropagation();
        }
    });
    //  There are more than 70 'keypress' handlers on a Confluence page, and we want to be first to skip them all. Note: We hope we don't bypass some useful key binding, apart from the keyboard shortcuts.
    const allEvents = $._data(document, "events").keypress;
    // Remove it from last
    const handler = allEvents.pop();
    // Add this handler ahead of all others
    allEvents.unshift(handler);
}

function get_issue_elements(issueKey, currentIssueOnly){
    let elements = [];
    // Jira issue macros
    elements = elements.concat( currentIssueOnly ?  Array.prototype.slice.call($(".jira-issue[data-jira-key='" + issueKey + "']")) :
        Array.prototype.slice.call($(".jira-issue")) );

    // C4J panels
    elements = elements.concat( currentIssueOnly ?  Array.prototype.slice.call($(".c4j-panel[data-c4j-issuekey*='" + issueKey + "']")) :
        Array.prototype.slice.call($(".c4j-panel")) );

    // Jblocks
    elements = elements.concat( currentIssueOnly ?  Array.prototype.slice.call($(".jcreate-issuekey-" + issueKey.toLowerCase())) :
        Array.prototype.slice.call($("[class*='jcreate-issuekey-']")) );

    // JReq panels
    elements = elements.concat( currentIssueOnly ?  Array.prototype.slice.call($(".rq-panel[data-rq-issuekey='" + issueKey + "']")) :
        Array.prototype.slice.call($(".rq-panel")) );

    // Sorts the elements by their order on the page
    elements.sort((a, b) =>
        a.compareDocumentPosition(b) & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : 1
    );
    return elements;
}

function scrollIssueIntoView(type, issueKey, scroll2current) {
    // Get All jira-issue elements - i.e. all Jira macros
    const jiraIssues = get_issue_elements(issueKey, scroll2current);

    const urlParams = new URLSearchParams(window.location.search);
    const ignorePageTitle = urlParams.has('jiraLink')

    if (type === -1)
        jiraIssues.reverse();

    for (let i = 0; i < jiraIssues.length; i++) {
        let macroOffset = $(jiraIssues[i]).offset().top;
        let page_title = $(".pagetitle");
        if( (type === 1 && scrollY < macroOffset) || (type === -1 && scrollY > macroOffset) ){
             if(i === 0 && type === 1 && page_title.height() && !ignorePageTitle)
                 macroOffset = macroOffset - page_title.offset().top - page_title.height();
            $([document.documentElement, document.body]).animate({
                scrollTop: macroOffset
            }, 1000, function () {
                if (jiraIssues[i].parentElement) {
                    setTimeout(function () {
                        if (jiraIssues[i].parentElement) jiraIssues[i].parentElement.style.backgroundColor = "";
                    }, 500);
                    jiraIssues[i].parentElement.style.backgroundColor = "aliceblue";
                }
            });
            break;
        }
    }
}

function receiveMessage(event) {
    // Do we trust the sender of this message?
    if (event.origin !== window.origin)
        return;

    const message = event.data;

    if (message && message.type) {
        switch (message.type) {
            case "scroll issue":
                if (message.data && message.data.changeIssue
                    && message.data.issueKey) {
                    scrollIssueIntoView(message.data.changeIssue,
                        message.data.issueKey, false);
                }
                break;
            case "iframe scroll":
                if (message.data) {
                    const jiraPanels = Array.prototype.slice.call($('[data-c4j-issuekey="' + message.data.key + '"], [data-rq-issuekey="' + message.data.key + '"]'));
                    if (jiraPanels.length > 0 && message.data.panelOrPage) {
                        $("#main-content").html($(jiraPanels[0]).closest(".c4j-panel, .rq-panel").html());
                        $(".page-metadata, #main-header").css("display", "none");
                    }
                    if (message.data.removeCreateIssueButton === true) {
                        $('head').append('<style type="text/css" id="methoda-hide-create-issue">' +
                            '[data-key="com.atlassian.confluence.plugins.confluence-jira-content:create-Jira-issue-summary"] {' +
                            'display: none !important;' +
                            '}' +
                            '</style>');
                    }
                    window.parent.postMessage({data: jiraPanels.length, type: "show iframe"},
                        window.origin);
                }
                break;
            case "configuration":
                config = message.data;
                if(config.allowPageEdit === "false")
                    removeEditButton()
                checkVersion(new URLSearchParams(window.location.search).get("issueKey"));
        }
    }
}


async function getAllPagesVersions(allPagesIds) {
    const limit = 200;
    let allPagesVersions = [];
    for (let i = 0; i < allPagesIds.length; i += limit) {
        const pages = await restCallPagePreview('get', AJS.Confluence.getBaseUrl() + "/rest/api/search?cql=id%20in%20(" +
            allPagesIds.slice(i, i + limit).join() + ")&expand=content.version&limit=" + limit);
        allPagesVersions = allPagesVersions.concat(pages.results);
    }
    return new Map(allPagesVersions.map(i => [i.content.id, i.content.version.number]));
}

async function checkVersion(issueKey) {
    if (!config || config.trackPageChanges !== "true" ||!issueKey) return;

    const response = await restCallPagePreview('get', AJS.Confluence.getBaseUrl() +
        "/rest/pagesinissueresource/1.0/integrity/linkedPagesVersions?issueKey=" + issueKey);

    if (response.id !== "0") {
        console.log("No information found for page and issue");
        return;
    }

    const allPagesVersionInJira = new Map(JSON.parse(response.text).results.map(i => [i.content.id, i.content.version.number]));
    const allPagesIds = Array.from(allPagesVersionInJira.keys());
    const allPagesActualVersion = await getAllPagesVersions(allPagesIds);

    let numOfPageChanged = 0, currentPageChanged = false;
    for (let pageId of allPagesIds) {
        if (allPagesVersionInJira.get(pageId) !== allPagesActualVersion.get(pageId)) {
            numOfPageChanged++;
            if (pageId === AJS.params.pageId) {
                currentPageChanged = true;
                AJS.flag({
                    type: 'warning',
                    body: 'This page has changed since last time you viewed it.' +
                        '<ul class="aui-nav-actions-list">' +
                        '<li><a class="aui-button aui-button-link" href="' + AJS.params.baseUrl + '/pages/diffpagesbyversion.action?pageId=' +
                        AJS.params.pageId + '&selectedPageVersions=' + allPagesVersionInJira.get(pageId) + '&selectedPageVersions=' +
                        allPagesActualVersion.get(pageId) + '">Compare Changes</a></li>' +
                        '<li><button class="aui-button aui-button-link" onclick="acknowledgeChanges()">Acknowledge</button></li>' +
                        '</ul>'
                });
            }
        }
    }
    window.parent.postMessage({
            data: {
                numOfPageChanged: numOfPageChanged,
                currentPageChanged: currentPageChanged
            }, type: "page updated"
        },
        window.origin);
}

function acknowledgeChanges() {
    restCallPagePreview('put', AJS.Confluence.getBaseUrl() +
        "/rest/pagesinissueresource/1.0/integrity/linkedPageVersion?issueKey=" +
        new URLSearchParams(window.location.search).get("issueKey") +
        "&pageId=" + AJS.params.pageId + "&version=" + AJS.Meta.get("page-version"))
        .then(() => {
            location.reload();
            window.parent.postMessage({data: 1, type: "acknowledge page updated"},
                window.origin);
        });
}

async function restCallPagePreview(method, url) {
    return new Promise((resolve, reject) =>
        AJS.$.ajax({
            url: url,
            type: method,
            dataType: 'json',
            async: true,
            success: function (data) {
                resolve(data);
            },
            error: function (xhr, ajaxOptions, thrownError) {
                console.log("xhr", xhr);
                if (xhr.status === 401) {
                    console.log("in if");
                    AppLinks.authenticateRemoteCredentials(xhr.responseText, async function () {
                        resolve(await restCallPagePreview('get', url));
                    }, function () {
                        console.log("error authenticating");
                    })
                    return
                }
                AJS.flag({
                    type: 'error',
                    body: "An error occurred, please try again.",
                    close: 'auto'
                });
                console.log("error", thrownError)
            }
        })
    )
}