/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.servlet;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.sun.istack.NotNull;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Named
public class SecurityInterceptorEnhancer
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SecurityInterceptorEnhancer.class);
    private static final Function<URI, Option<String>> URL_TO_STRING = uri -> Option.some((Object)uri.toString());
    private static final Function<URI, String> URL_ORIGIN = uri -> SecurityInterceptorEnhancer.getOrigin(uri.getHost(), uri.getPort());
    private static final Function<URI, String> URL_ORIGIN_WITH_SCHEME = SecurityInterceptorEnhancer::getOriginWithScheme;
    private final Cache<String, Set<String>> myFrameAncestorsCache;
    private final ReadOnlyApplicationLinkService myLinkService;

    @Inject
    public SecurityInterceptorEnhancer(@ComponentImport ReadOnlyApplicationLinkService linkService, @ComponentImport CacheManager cacheManager) {
        this.myLinkService = linkService;
        this.myFrameAncestorsCache = cacheManager.getCache("com.methoda.plugins.pagePreview.app-links", (CacheLoader)new FrameAncestorsLoader());
    }

    public void setContentSecurityPolicy(HttpServletResponse httpResponse, @Nullable String currentHeader) {
        logger.trace("current header: " + currentHeader);
        Set ancestorSources = (Set)this.myFrameAncestorsCache.get((Object)"*");
        String newHeader = this.addAncestorSources(StringUtils.trimToEmpty((String)currentHeader), ancestorSources);
        httpResponse.setHeader("Content-Security-Policy", newHeader);
        logger.trace("new header: " + newHeader);
    }

    private String addAncestorSources(@NotNull String currentHeader, Set<String> ancestorSources) {
        if (StringUtils.isEmpty((CharSequence)currentHeader)) {
            return this.buildFrameAncestorsOption(ancestorSources);
        }
        Object[] directives = currentHeader.split(";");
        for (int i = 0; i < directives.length; ++i) {
            String directive = directives[i].trim();
            if (!directive.toLowerCase().startsWith("frame-ancestors ")) continue;
            directives[i] = this.extendFrameAncestorsDirective(directive, ancestorSources);
            return StringUtils.join((Object[])directives, (String)";");
        }
        if (!currentHeader.endsWith(";")) {
            currentHeader = currentHeader + ";";
        }
        return currentHeader + this.buildFrameAncestorsOption(ancestorSources);
    }

    private String extendFrameAncestorsDirective(String originalDirective, Set<String> ancestorSources) {
        String[] options = originalDirective.substring("frame-ancestors ".length()).split("\\s+");
        if (!(options.length == 0 || options.length == 1 && "'none'".equalsIgnoreCase(options[0]))) {
            LinkedHashSet<String> ancestorSet = new LinkedHashSet<String>(Arrays.asList(options));
            ancestorSet.addAll(ancestorSources);
            return this.buildFrameAncestorsOption(ancestorSet);
        }
        return this.buildFrameAncestorsOption(ancestorSources);
    }

    private String buildFrameAncestorsOption(Iterable<String> frameAncestors) {
        return "frame-ancestors " + StringUtils.join(frameAncestors, (String)" ");
    }

    @NotNull
    private Predicate<URI> sameOrigin(final String origin) {
        return new Predicate<URI>(){

            public boolean apply(URI uri) {
                return StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)URL_ORIGIN.apply(uri)), (CharSequence)origin);
            }
        };
    }

    @NotNull
    private Set<URI> getKnownReferrers() {
        Iterable links = this.myLinkService.getApplicationLinks();
        LinkedHashSet knownReferrers = Sets.newLinkedHashSet();
        for (ReadOnlyApplicationLink link : links) {
            knownReferrers.add(SecurityInterceptorEnhancer.cutUrl(link.getDisplayUrl()));
            knownReferrers.add(SecurityInterceptorEnhancer.cutUrl(link.getRpcUrl()));
        }
        return knownReferrers;
    }

    @NotNull
    private static URI cutUrl(@NotNull URI url) {
        try {
            return new URI(url.getScheme(), null, url.getHost(), url.getPort(), null, null, null);
        }
        catch (URISyntaxException var2) {
            logger.error("Cannot cut the URL " + url, (Throwable)var2);
            return url;
        }
    }

    private static String getOriginWithScheme(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (scheme == null) {
            return SecurityInterceptorEnhancer.getOrigin(uri.getHost(), port);
        }
        if (scheme.equals("https") && port == 443 || scheme.equals("http") && port == 80) {
            port = -1;
        }
        String withScheme = scheme + "://" + uri.getHost();
        return port > 0 ? withScheme + ":" + port : withScheme;
    }

    private static String getOrigin(@NotNull String host, int port) {
        return port > 0 && port != 80 ? host + ":" + port : host;
    }

    public void destroy() throws Exception {
        logger.warn(this + " stopping");
    }

    private class FrameAncestorsLoader
    implements CacheLoader<String, Set<String>> {
        private FrameAncestorsLoader() {
        }

        @Nonnull
        public Set<String> load(@Nonnull String referrer) {
            LinkedHashSet<String> ancestorsSet = new LinkedHashSet<String>();
            Iterable knownReferrers = SecurityInterceptorEnhancer.this.getKnownReferrers().stream().map(URL_ORIGIN_WITH_SCHEME).collect(Collectors.toList());
            ancestorsSet.add("'self'");
            ancestorsSet.addAll(Sets.newLinkedHashSet((Iterable)knownReferrers));
            return ancestorsSet;
        }
    }

    private class KnownReferrerLoader
    implements CacheLoader<String, Option<String>> {
        private KnownReferrerLoader() {
        }

        @Nonnull
        public Option<String> load(@Nonnull String referrer) {
            Set knownReferrers = SecurityInterceptorEnhancer.this.getKnownReferrers();
            if (CollectionUtils.isEmpty((Collection)knownReferrers)) {
                return Option.none();
            }
            try {
                String origin = (String)URL_ORIGIN.apply(new URI(referrer));
                return Iterables.findFirst((Iterable)knownReferrers, (Predicate)SecurityInterceptorEnhancer.this.sameOrigin(origin)).flatMap(URL_TO_STRING::apply);
            }
            catch (URISyntaxException var4) {
                logger.error("Cannot load know referrer", (Throwable)var4);
                return Option.none();
            }
        }
    }
}

