/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.servlet;

import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PreviewPagesServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(PreviewPagesServlet.class);
    @ConfluenceImport
    private final PageBuilderService pageBuilderService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;

    @Inject
    public PreviewPagesServlet(PageBuilderService pageBuilderService, ApplicationProperties applicationProperties) {
        this.pageBuilderService = pageBuilderService;
        this.applicationProperties = applicationProperties;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws IOException {
        this.pageBuilderService.assembler().resources().requireWebResource("com.methoda.plugins.pagePreview4Conf:page-preview-resources");
        try {
            String issueKey = req.getParameter("issueKey");
            String pageId = req.getParameter("pageId");
            ImmutableMap parameters = ImmutableMap.of((Object)"issueKey", (Object)issueKey, (Object)"pageId", (Object)pageId);
            response.addHeader("issueKey", issueKey);
            response.addHeader("pageId", pageId);
            response.setContentType("text/html;charset=utf-8");
            VelocityUtils.writeRenderedTemplate((Writer)response.getWriter(), (String)"templates/preview-pages.vm", (Map)parameters);
        }
        catch (Exception e) {
            log.error("error trying to open preview pages servlet: ", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.applicationProperties.getBaseUrl() + "/plugins/servlet/pagePreview/login?destination=" + this.getUri(request).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

