/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.servlet;

import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.confluence.util.SeraphUtils;
import com.methoda.plugins.pagePreview.servlet.SecurityInterceptorEnhancer;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityFilter
extends ConfluenceAuthenticator
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SecurityFilter.class);
    private final SecurityInterceptorEnhancer securityInterceptorEnhancer;

    public SecurityFilter(SecurityInterceptorEnhancer enhancer) {
        log.debug("in SecurityFilter constructor");
        log.debug("enhancer: " + enhancer);
        this.securityInterceptorEnhancer = enhancer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        log.debug("in SecurityFilter init function");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("in SecurityFilter doFilter function");
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            final HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            this.init(new HashMap(), SeraphUtils.getConfig((HttpServletRequest)httpRequest));
            HttpServletResponseWrapper httpServletResponse = new HttpServletResponseWrapper(httpResponse){

                public void addCookie(Cookie cookie) {
                    log.debug("in SecurityFilter HttpServletResponseWrapper addCookie function");
                    log.debug("cookie: " + cookie);
                    String header = cookie.getName() + "=" + cookie.getValue() + "; Max-Age=" + cookie.getMaxAge() + "; Path=" + cookie.getPath() + "; SameSite=None; Secure";
                    this.setHeader("Set-Cookie", header);
                    log.debug("header: " + header);
                    super.addCookie(cookie);
                }

                public void setHeader(String name, String value) {
                    log.debug("in SecurityFilter HttpServletResponseWrapper setHeader function");
                    log.debug("name: " + name + "; value: " + value);
                    if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"Content-Security-Policy")) {
                        SecurityFilter.this.securityInterceptorEnhancer.setContentSecurityPolicy(httpResponse, value);
                    } else {
                        super.setHeader(name, value);
                    }
                }
            };
            log.debug("before chain");
            chain.doFilter(request, (ServletResponse)httpServletResponse);
        } else {
            log.debug("not http request");
            chain.doFilter(request, response);
        }
    }
}

