/*
 * Decompiled with CFR 0.152.
 */
package com.methoda.plugins.pagePreview.rest;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.net.Request;
import com.methoda.plugins.pagePreview.exception.UnauthorizedException;
import com.methoda.plugins.pagePreview.rest.SendRest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Named
@Path(value="/integrity")
public class PageIntegrityResource {
    private final ApplicationLinkService applicationLinkService;

    @Inject
    public PageIntegrityResource(@ComponentImport ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    @GET
    @Path(value="/linkedPageVersion")
    @Produces(value={"application/json"})
    public Response getPageVersionForIssue(@QueryParam(value="issueKey") String issueKey, @QueryParam(value="pageId") String pageId) {
        try {
            return Response.ok((Object)SendRest.sendToJira(Request.MethodType.GET, "/rest/pagesresource/1.0/integrity/linkedPageVersion?issueKey=" + issueKey + "&pageId=" + pageId, this.applicationLinkService)).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)401).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/linkedPagesVersions")
    @Produces(value={"application/json"})
    public Response getPagesVersionsForIssue(@QueryParam(value="issueKey") String issueKey) {
        try {
            return Response.ok((Object)SendRest.sendToJira(Request.MethodType.GET, "/rest/pagesresource/1.0/integrity/linkedPagesVersions?issueKey=" + issueKey, this.applicationLinkService)).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)401).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/linkedPageVersion")
    @Produces(value={"application/json"})
    public Response updatePageVersionForIssue(@QueryParam(value="issueKey") String issueKey, @QueryParam(value="pageId") String pageId, @QueryParam(value="version") Integer version) {
        try {
            return Response.ok((Object)SendRest.sendToJira(Request.MethodType.PUT, "/rest/pagesresource/1.0/integrity/linkedPageVersion?issueKey=" + issueKey + "&pageId=" + pageId + "&version=" + version, this.applicationLinkService)).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)401).entity((Object)e.getMessage()).build();
        }
    }
}

