/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.server.api;

import hu.metainf.plugin.confluence.contentexporter.model.CreateProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.UpdateProfileDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Api(description="the profiles API")
public interface ProfilesApi {
    @GET
    @Path(value="/global")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class, responseContainer="List")})
    public Response profilesGlobalGet();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesPost(@Valid @NotNull CreateProfileDto var1);

    @DELETE
    @Path(value="/{profileId}")
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation", response=Void.class)})
    public Response profilesProfileIdDelete(@PathParam(value="profileId") @ApiParam(value="ID of the profile to update") Long var1);

    @GET
    @Path(value="/{profileId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesProfileIdGet(@PathParam(value="profileId") @ApiParam(value="ID of the profile to return") Long var1);

    @PUT
    @Path(value="/{profileId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesProfileIdPut(@PathParam(value="profileId") @ApiParam(value="ID of the profile to update") Long var1, @Valid @NotNull UpdateProfileDto var2);

    @GET
    @Path(value="/space/{spaceKey}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class, responseContainer="List")})
    public Response profilesSpaceSpaceKeyGet(@PathParam(value="spaceKey") @ApiParam(value="Key of the selected space") String var1);
}

