/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.server.api;

import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePageTreeDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportDetailsDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParametersDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProgressDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.File;

@Api(description="the export API")
public interface ExportApi {
    @GET
    @Path(value="/download")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=File.class)})
    public Response exportDownloadGet(@QueryParam(value="hash") @NotNull @ApiParam(value="ID of queued export") String var1);

    @GET
    @Path(value="/{pageId}/exportParameters")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportParametersDto.class)})
    public Response exportPageIdExportParametersGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1);

    @GET
    @Path(value="/{pageId}")
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=Void.class)})
    public Response exportPageIdGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1, @QueryParam(value="hash") @NotNull @ApiParam(value="ID of queued export") String var2);

    @POST
    @Path(value="/{pageId}/init")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportDetailsDto.class)})
    public Response exportPageIdInitPost(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1, @Valid @NotNull ExportParametersDto var2);

    @GET
    @Path(value="/{pageId}/pageTree")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ConfluencePageTreeDto.class)})
    public Response exportPageIdPageTreeGet(@PathParam(value="pageId") @ApiParam(value="ID of page to export") Long var1);

    @GET
    @Path(value="/poll")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProgressDto.class)})
    public Response exportPollGet(@QueryParam(value="hash") @NotNull @ApiParam(value="ID of current export") String var1);
}

