/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.plugins.rest.api.multipart.MultipartForm;
import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.CexException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.mapper.FontMapper;
import hu.metainf.plugin.confluence.contentexporter.model.AttachmentDto;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontDto;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import hu.metainf.plugin.confluence.contentexporter.server.api.FontsApi;
import hu.metainf.plugin.confluence.contentexporter.service.FontService;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.confluence.contentexporter.util.ErrorCollection;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import hu.metainf.plugin.confluence.contentexporter.util.ValidatorHelper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;

@Component
@Path(value="/fonts")
public class FontsController
implements FontsApi {
    private final FontService fontService;
    private final FontRepository fontRepository;
    private final GlobalSettingsManager settingsManager;
    private final PermissionService permissionService;
    private static final String CSS_NAME_PARAM = "cssName";

    @Inject
    public FontsController(FontService fontService, FontRepository fontRepository, GlobalSettingsManager settingsManager, PermissionService permissionService) {
        this.fontService = fontService;
        this.fontRepository = fontRepository;
        this.settingsManager = settingsManager;
        this.permissionService = permissionService;
    }

    @Override
    public Response fontsAttachmentMaxSizeGet() {
        AttachmentDto result = new AttachmentDto();
        long attachmentMaxSize = this.settingsManager.getGlobalSettings().getAttachmentMaxSize() / 1024L / 1024L;
        result.setAttachmentMaxSize(Long.valueOf(attachmentMaxSize));
        return Response.ok((Object)result).build();
    }

    @Override
    public Response fontsFontIdDelete(Long fontId) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        if (this.fontRepository.getById(fontId.longValue()) == null) {
            throw new NotFoundException("cex.fonts.error.notFound", new Map.Entry[]{Map.entry("id", fontId)});
        }
        if (this.fontRepository.getById(fontId.longValue()) == null) {
            throw new NotFoundException("cex.fonts.error.notFound", new Map.Entry[]{Map.entry("id", fontId)});
        }
        this.fontService.delete(fontId);
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }

    @Override
    public Response fontsGet() {
        List<Font> fonts = this.fontService.loadAll();
        List response = FontMapper.INSTANCE.fontListToFontDtoList(fonts);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response fontsUploadPost(String name, String cssName, MultipartForm fileListMultipart) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        name = fileListMultipart.getFilePart("name").getValue();
        ValidatorHelper.validateNotBlank((String)name, (String)"name");
        if (fileListMultipart.getFilePart(CSS_NAME_PARAM) != null) {
            cssName = fileListMultipart.getFilePart(CSS_NAME_PARAM).getValue();
        }
        ValidatorHelper.validateNotBlank((String)name, (String)"name");
        Font newFont = new Font();
        newFont.setName(name);
        newFont.setCssName(cssName);
        LinkedList files = new LinkedList(fileListMultipart.getFileParts("fileList"));
        if (files.isEmpty()) {
            throw new BadRequestException("cex.fonts.save.error.noFiles", new Map.Entry[0]);
        }
        if (files.size() > 4) {
            throw new BadRequestException("cex.fonts.save.error.tooManyFiles", new Map.Entry[0]);
        }
        files.forEach(filePart -> {
            FontFile fontFile = new FontFile();
            fontFile.setFileName(filePart.getName());
            try {
                fontFile.setFontData(IOUtils.toByteArray((InputStream)filePart.getInputStream(), (long)filePart.getSize()));
            }
            catch (IOException e) {
                throw new CexException("cex.fonts.save.error", (Throwable)e);
            }
            newFont.addFile(fontFile);
        });
        OperationResult saveResult = this.fontService.save(newFont);
        if (!saveResult.isSuccess()) {
            ErrorCollection errors = saveResult.getErrors();
            if (!errors.getErrorMessages().isEmpty()) {
                Optional<Map.Entry> extensionError = errors.getErrorMessages().entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("hu.metainf.plugin.confluence.contentexporter.invalid-extension")).findFirst();
                if (extensionError.isPresent()) {
                    throw new BadRequestException("cex.fonts.save.error.invalidExtension", new Map.Entry[0]);
                }
                throw new CexException("cex.fonts.save.error", new Map.Entry[0]);
            }
            String globalErrorMessage = errors.getGlobalErrorMessage();
            if (globalErrorMessage != null) {
                throw new CexException(String.format("%s: %s", "cex.fonts.save.error", globalErrorMessage), new Map.Entry[0]);
            }
        }
        FontDto response = FontMapper.INSTANCE.fontToFontDto((Font)saveResult.getData());
        response.setFiles(Collections.emptyList());
        return Response.ok((Object)response).build();
    }
}

