/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.mapper.ConfigurationMapper;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import hu.metainf.plugin.confluence.contentexporter.model.ConfigurationDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.ConfigurationApi;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@Path(value="/configuration")
public class ConfigurationController
implements ConfigurationApi {
    private final ConfigurationRepository configurationRepository;
    private final PermissionService permissionService;

    @Inject
    public ConfigurationController(ConfigurationRepository configurationRepository, PermissionService permissionService) {
        this.configurationRepository = configurationRepository;
        this.permissionService = permissionService;
    }

    @Override
    public Response configurationGet() {
        ConfigurationDto response = ConfigurationMapper.INSTANCE.configurationToConfigurationDto(this.configurationRepository.load());
        return Response.ok((Object)response).build();
    }

    @Override
    public Response configurationPut(ConfigurationDto configurationDto) {
        this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        Configuration configuration = ConfigurationMapper.INSTANCE.configurationDtoToConfiguration(configurationDto);
        ConfigurationDto response = ConfigurationMapper.INSTANCE.configurationToConfigurationDto((Configuration)this.configurationRepository.save(configuration));
        return Response.ok((Object)response).build();
    }
}

