/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import hu.metainf.plugin.confluence.contentexporter.exporter.ImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ConfluenceImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ExternalHttpImageFetcher;
import java.io.InputStream;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneImageFetcher
implements ImageFetcher {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneImageFetcher.class);
    private final String baseUrl;
    private final ConfluenceImageFetcher confluenceImageFetcher;
    private final ExternalHttpImageFetcher externalHttpImageFetcher;

    public StandaloneImageFetcher(String baseUrl, ConfluenceImageFetcher confluenceImageFetcher, ExternalHttpImageFetcher externalHttpImageFetcher) {
        this.baseUrl = baseUrl;
        this.confluenceImageFetcher = confluenceImageFetcher;
        this.externalHttpImageFetcher = externalHttpImageFetcher;
    }

    public InputStream createImageInputStream(String uri, String ... params) {
        if ((uri = uri.replace("&amp;", "&")).startsWith(this.baseUrl)) {
            uri = uri.substring(this.baseUrl.length());
        }
        ArrayList<Object> imageFetchers = new ArrayList<Object>();
        if (HttpUtil.isAbsoluteUrl((String)uri)) {
            imageFetchers.add(this.externalHttpImageFetcher);
        } else {
            imageFetchers.add(this.confluenceImageFetcher);
        }
        for (ImageFetcher imageFetcher : imageFetchers) {
            InputStream is = imageFetcher.createImageInputStream(uri, new String[0]);
            logger.debug("Download image [{}] from {}: {}", new Object[]{imageFetcher.getClass().getSimpleName(), uri, is != null ? "OK" : "FAIL"});
            if (is == null) continue;
            return is;
        }
        return null;
    }
}

