/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.dao.standalone;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.EntityPersistenceException;
import hu.metainf.plugin.confluence.contentexporter.dao.standalone.AbstractRepositoryImpl;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationRepositoryImpl
extends AbstractRepositoryImpl<Configuration>
implements ConfigurationRepository {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationRepositoryImpl.class);
    private static final String PROPERTY_KEY = "Configuration";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final PluginSettingsFactory psf;

    public ConfigurationRepositoryImpl(PluginSettingsFactory psf, AccessModeService accessModeService) {
        super(accessModeService);
        this.psf = psf;
    }

    @Override
    public Configuration load() {
        Configuration configuration;
        PluginSettings globalSettings = this.psf.createGlobalSettings();
        Object property = globalSettings.get(PROPERTY_KEY);
        if (property != null) {
            String configurationJson = (String)property;
            try {
                configuration = (Configuration)this.objectMapper.readValue(configurationJson, Configuration.class);
            }
            catch (IOException e) {
                logger.error("Could not parse invalid configuration: {}. Returning default one.", (Object)configurationJson, (Object)e);
                configuration = new Configuration();
            }
        } else {
            logger.debug("No Configuration exists. Returning a default one.");
            configuration = new Configuration();
        }
        configuration.setPageBreakOptionEnabled(false);
        return configuration;
    }

    @Override
    public Configuration doSave(Configuration configuration) {
        PluginSettings globalSettings = this.psf.createGlobalSettings();
        try {
            globalSettings.put(PROPERTY_KEY, (Object)this.objectMapper.writeValueAsString((Object)configuration));
        }
        catch (JsonProcessingException e) {
            throw new EntityPersistenceException("Could not save configuration. Please refer log files.", (Throwable)e);
        }
        return configuration;
    }

    public Configuration getById(long id) {
        return this.load();
    }

    public List<Configuration> findAll() {
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        result.add(this.load());
        return result;
    }

    public void delete(Configuration entity) {
        throw new UnsupportedOperationException();
    }
}

