/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.controllers;

import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.importexport.resource.DownloadResourceManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.ApplicationProperties;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.StylesheetRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.AddonInfo;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.OutputWriterFactory;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.BootstrapUtils;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.ServerConnector;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandaloneResourceLoader;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ConfluenceImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.imageloader.ExternalHttpImageFetcher;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentExporterFactory
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ContentExporterFactory.class);
    private final transient ExportProfileRepository profileRepository;
    private final transient StylesheetRepository stylesheetRepository;
    private final transient OutputWriterFactory outputWriterFactory;
    private final transient ConfluenceContentService confluenceContentService;
    private final transient ServerConnector serverConnector;
    private final transient ApplicationProperties applicationProperties;
    private final transient ContextPathHolder contextPathHolder;
    private final transient GlobalSettingsManager settingsManager;
    private final transient BootstrapManager bootstrapManager;
    private final transient DownloadResourceManager downloadResourceManager;
    private final transient PluginAccessor pluginAccessor;
    private final transient PageManager pageManager;
    private final transient PermissionManager permissionManager;

    public ContentExporterFactory(ExportProfileRepository profileRepository, StylesheetRepository stylesheetRepository, OutputWriterFactory outputWriterFactory, ConfluenceContentService confluenceContentService, ServerConnector serverConnector, ApplicationProperties applicationProperties, ContextPathHolder contextPathHolder, GlobalSettingsManager settingsManager, BootstrapManager bootstrapManager, DownloadResourceManager downloadResourceManager, PageManager pageManager, PermissionManager permissionManager, PluginAccessor pluginAccessor) {
        this.profileRepository = profileRepository;
        this.stylesheetRepository = stylesheetRepository;
        this.outputWriterFactory = outputWriterFactory;
        this.confluenceContentService = confluenceContentService;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.serverConnector = serverConnector;
        this.applicationProperties = applicationProperties;
        this.contextPathHolder = contextPathHolder;
        this.settingsManager = settingsManager;
        this.bootstrapManager = bootstrapManager;
        this.downloadResourceManager = downloadResourceManager;
        this.pluginAccessor = pluginAccessor;
    }

    public ContentExporter createContentExporter(ExportParameters exportParameters, Renderer renderer) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String baseUrl = this.getBaseUrl();
        String contextPath = this.getContextPath();
        StandaloneContentFetcher standaloneContentFetcher = new StandaloneContentFetcher(this.pageManager, this.permissionManager, this.confluenceContentService, renderer, baseUrl, contextPath, user);
        StandaloneImageFetcher standaloneImageFetcher = new StandaloneImageFetcher(baseUrl, new ConfluenceImageFetcher(this.downloadResourceManager), new ExternalHttpImageFetcher());
        File tempDirectory = BootstrapUtils.getTempDirectory(this.bootstrapManager);
        StandaloneContentExporter contentExporter = new StandaloneContentExporter(exportParameters, this.profileRepository, this.stylesheetRepository, standaloneContentFetcher, this.outputWriterFactory, new StandaloneResourceLoader(), tempDirectory, new ServerAddonInfo(this.pluginAccessor), standaloneImageFetcher, this.settingsManager.getGlobalSettings().getBaseUrl(), this.serverConnector.isPre68(), AuthenticatedUserThreadLocal.get().getKey().getStringValue(), null);
        logger.debug("Confluence home: {}", (Object)this.applicationProperties.getLocalHomeDirectory());
        logger.debug("Web app context path: {}", (Object)this.getContextPath());
        logger.debug("HttpContext context path: {}", (Object)new StaticHttpContext().getActiveRequest().getContextPath());
        logger.debug("Base URL: {}", (Object)baseUrl);
        return contentExporter;
    }

    private String getBaseUrl() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    private String getContextPath() {
        return this.contextPathHolder.getContextPath();
    }

    private static class ServerAddonInfo
    implements AddonInfo {
        private final PluginAccessor pluginAccessor;

        public ServerAddonInfo(PluginAccessor pluginAccessor) {
            this.pluginAccessor = pluginAccessor;
        }

        public String getVersion() {
            Plugin plugin = this.pluginAccessor.getPlugin("com.metainf.confluence.plugin.pagetreeexporter.pagetree-word-exporter-plugin");
            return plugin.getPluginInformation().getVersion();
        }
    }
}

