/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminController
extends HttpServlet {
    private static final String SPACE_KEY = "space";
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final TemplateRenderer templateRenderer;

    @Inject
    public AdminController(UserManager userManager, UserAccessor userAccessor, LoginUriProvider loginUriProvider, SpaceManager spaceManager, TemplateRenderer templateRenderer) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.loginUriProvider = loginUriProvider;
        this.spaceManager = spaceManager;
        this.templateRenderer = templateRenderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            UserKey userKey = this.userManager.getRemoteUserKey(request);
            ConfluenceUser user = this.userAccessor.getExistingUserByKey(userKey);
            if (userKey == null || user == null) {
                this.redirectToLogin(request, response);
                return;
            }
            HashMap<String, Long> context = new HashMap<String, Long>();
            String spaceKey = request.getParameter(SPACE_KEY);
            response.setContentType("text/html;charset=utf-8");
            if (spaceKey != null) {
                Space space = this.spaceManager.getSpace(spaceKey);
                if (space == null) {
                    response.setStatus(404);
                    return;
                }
                context.put("spaceId", space.getId());
            }
            this.templateRenderer.render("/gui/react/index.vm", context, (Writer)response.getWriter());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        Object requestURL = request.getRequestURL().toString();
        if (request.getQueryString() != null) {
            requestURL = (String)requestURL + "?" + request.getQueryString();
        }
        return URI.create((String)requestURL);
    }
}

