/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone.output;

import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.exporter.Bookmarks;
import hu.metainf.plugin.confluence.contentexporter.exporter.Images;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.IoUtil;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.ContentStore;
import hu.metainf.plugin.confluence.contentexporter.exporter.output.FileBasedOutputWriter;
import hu.metainf.plugin.confluence.contentexporter.exporter.velocity.VelocityTemplate;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.Formatting;
import hu.metainf.plugin.confluence.contentexporter.util.ClassLoaderUtil;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneDocWriter
extends FileBasedOutputWriter {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneDocWriter.class);
    private static final String PAGE_BREAK_TEMPLATE = "<br style='mso-special-character:line-break;page-break-after:always;display:block' class='%s'/>";

    public StandaloneDocWriter(Formatting formatting, Bookmarks bookmarks, List<? extends ConfluencePage> pages) {
        super(formatting, bookmarks, pages, null, new ContentStore());
    }

    public void customizeDocumentPrefix(VelocityTemplate template) {
        File cssFile = new File(this.exportContext.getWorkingDirectory(), "combined.css");
        try {
            template.put("wordCss", (Object)IoUtil.read((File)cssFile));
        }
        catch (IOException e) {
            logger.warn("Can't read combined CSS file: {}", (Object)cssFile);
        }
    }

    public String getPageTitle(String bookmarkId, String pageTitle, int pageHierarchicalLevel) {
        return "<a name='" + bookmarkId + "'></a><h1>" + pageTitle + "</h1>";
    }

    public File convert(File sourceFile) throws ContentExporterException {
        return (File)ClassLoaderUtil.runWithClassLoaderAsContentExporterContext(() -> this.doConversion(sourceFile), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    private File doConversion(File sourceFile) throws ContentExporterException {
        try {
            Images images = this.exportContext.getImages();
            File workingDirectory = this.exportContext.getWorkingDirectory();
            File outputFile = this.createOutputFile(sourceFile, "doc");
            Session session = Session.getInstance((Properties)new Properties(), null);
            MimeMessage message = new MimeMessage(session);
            MimeMultipart mpart = new MimeMultipart("related");
            MimeBodyPart bodypart = new MimeBodyPart();
            bodypart.setDataHandler(new DataHandler((DataSource)new FileDataSource(sourceFile.getAbsolutePath())));
            bodypart.setHeader("Content-Type", "text/html; charset=UTF-8");
            bodypart.setHeader("Content-Transfer-Encoding", "quoted-printable");
            bodypart.setHeader("Content-Location", "file:///C:/export.html");
            mpart.addBodyPart((BodyPart)bodypart);
            for (String imageFilename : images.getImageFilenameList()) {
                if (imageFilename.isEmpty()) continue;
                int p = imageFilename.lastIndexOf(46);
                String extension = imageFilename.substring(p + 1);
                MimeBodyPart imgpart = new MimeBodyPart();
                imgpart.setDataHandler(new DataHandler((DataSource)new FileDataSource(String.valueOf(workingDirectory) + "/" + imageFilename)));
                imgpart.addHeader("Content-Type", "image/" + extension);
                imgpart.addHeader("Content-Transfer-Encoding", "base64");
                imgpart.addHeader("Content-Location", "file:///C:/" + imageFilename);
                mpart.addBodyPart((BodyPart)imgpart);
            }
            this.addCustomStylesheet(mpart);
            this.addInlineStyles(mpart);
            message.setContent((Multipart)mpart);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                message.writeTo((OutputStream)fos);
            }
            return outputFile;
        }
        catch (MessagingException | IOException exception) {
            throw new ContentExporterException(exception);
        }
    }

    private void addCustomStylesheet(MimeMultipart mpart) throws MessagingException {
        this.addStylesheet(mpart, this.getCustomCssFile());
    }

    private File getCustomCssFile() {
        return new File(this.exportContext.getWorkingDirectory(), "custom.css");
    }

    private void addInlineStyles(MimeMultipart mpart) throws MessagingException {
        this.addStylesheet(mpart, this.getInlineStyles());
    }

    private void addStylesheet(MimeMultipart mpart, File styleSheet) throws MessagingException {
        MimeBodyPart stylesPart = new MimeBodyPart();
        stylesPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(styleSheet)));
        String fileName = styleSheet.getName();
        stylesPart.addHeader("Content-Type", "text/css; charset=utf-8; name=" + fileName);
        stylesPart.addHeader("Content-Transfer-Encoding", "8bit");
        stylesPart.addHeader("Content-Location", "file:///C:/" + fileName);
        mpart.addBodyPart((BodyPart)stylesPart);
    }

    protected String getPageBreakTemplate() {
        return PAGE_BREAK_TEMPLATE;
    }

    public void addSectionBreak(String pageClass) throws IOException {
        this.addPageBreak(pageClass);
    }
}

