/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.license;

import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;

public class LicenseInfo {
    private Option<PluginLicense> license;
    private boolean valid = false;
    private String error;
    private String licenseManagerUri;

    public LicenseInfo() {
        this(null);
    }

    public LicenseInfo(Option<PluginLicense> license) {
        this.license = license;
        if (license == null || !license.isDefined()) {
            this.error = "License not found";
        } else if (((PluginLicense)license.get()).getError().isDefined()) {
            this.error = ((LicenseError)((PluginLicense)license.get()).getError().get()).name();
        } else {
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public PluginLicense getLicense() {
        return this.isValid() ? (PluginLicense)this.license.get() : null;
    }

    public String getError() {
        return this.error;
    }

    public String getLicenseManagerUri() {
        return this.licenseManagerUri;
    }

    public void setLicenseManagerUri(String licenseManagerUri) {
        this.licenseManagerUri = licenseManagerUri;
    }

    public void setLicense(Option<PluginLicense> license) {
        this.license = license;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setError(String error) {
        this.error = error;
    }
}

