/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.server.api;

import hu.metainf.plugin.confluence.contentexporter.model.CreateProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.UpdateProfileDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Api(description="the profiles API")
public interface ProfilesApi {
    @GET
    @Path(value="/global")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class, responseContainer="List")})
    public Response profilesGlobalGet();

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesPost(@Valid @NotNull CreateProfileDto var1);

    @DELETE
    @Path(value="/{profileId}")
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation", response=Void.class)})
    public Response profilesProfileIdDelete(@PathParam(value="profileId") @ApiParam(value="ID of the profile to update") Long var1);

    @GET
    @Path(value="/{profileId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesProfileIdGet(@PathParam(value="profileId") @ApiParam(value="ID of the profile to return") Long var1);

    @PUT
    @Path(value="/{profileId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class)})
    public Response profilesProfileIdPut(@PathParam(value="profileId") @ApiParam(value="ID of the profile to update") Long var1, @Valid @NotNull UpdateProfileDto var2);

    @GET
    @Path(value="/space/{spaceKey}")
    @Produces(value={"application/json"})
    @ApiOperation(value="", notes="", tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation", response=ExportProfileDto.class, responseContainer="List")})
    public Response profilesSpaceSpaceKeyGet(@PathParam(value="spaceKey") @ApiParam(value="Key of the selected space") String var1);
}

