/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import hu.metainf.plugin.confluence.contentexporter.dao.ExportProfileRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.mapper.ExportProfileMapper;
import hu.metainf.plugin.confluence.contentexporter.model.CreateProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfile;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProfileDto;
import hu.metainf.plugin.confluence.contentexporter.model.UpdateProfileDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.ProfilesApi;
import hu.metainf.plugin.confluence.contentexporter.service.ExportProfileService;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.confluence.contentexporter.util.DtoValidatorHelper;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/profiles")
public class ProfileController
implements ProfilesApi {
    private final ExportProfileService exportProfileService;
    private final ExportProfileRepository profileRepository;
    private final PermissionService permissionService;

    @Inject
    public ProfileController(ExportProfileService exportProfileService, ExportProfileRepository profileRepository, PermissionService permissionService) {
        this.exportProfileService = exportProfileService;
        this.profileRepository = profileRepository;
        this.permissionService = permissionService;
    }

    @Override
    public Response profilesGlobalGet() {
        List profiles = this.profileRepository.findGlobals();
        List response = ExportProfileMapper.INSTANCE.exportProfileListToExportProfileDtoList(profiles);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response profilesPost(CreateProfileDto createProfileDto) {
        if (createProfileDto.getSpace() == null) {
            this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        } else {
            this.permissionService.checkCurrentUserHasSpaceAdminPermission(createProfileDto.getSpace());
        }
        DtoValidatorHelper.validate(createProfileDto);
        ExportProfile profile = ExportProfileMapper.INSTANCE.createExportProfileDtoToExportProfile(createProfileDto);
        ExportProfileDto response = ExportProfileMapper.INSTANCE.exportProfileToExportProfileDto(this.exportProfileService.saveProfile(profile));
        return Response.ok((Object)response).build();
    }

    @Override
    public Response profilesProfileIdDelete(Long profileId) {
        ExportProfile profile = (ExportProfile)this.profileRepository.getById(profileId.longValue());
        if (profile == null) {
            throw new NotFoundException("cex.profile.error.notFound", new Map.Entry[]{Map.entry("id", profileId)});
        }
        if (profile.getSpace() == null) {
            this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        } else {
            this.permissionService.checkCurrentUserHasSpaceAdminPermission(profile.getSpace());
        }
        this.profileRepository.delete((Object)profile);
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }

    @Override
    public Response profilesProfileIdGet(Long profileId) {
        ExportProfile profile = (ExportProfile)this.profileRepository.getById(profileId.longValue());
        if (profile == null) {
            throw new NotFoundException("cex.profile.error.notFound", new Map.Entry[]{Map.entry("id", profileId)});
        }
        if (profile.getSpace() != null) {
            this.permissionService.checkCurrentUserHasSpaceViewPermission(profile.getSpace());
        }
        ExportProfileDto response = ExportProfileMapper.INSTANCE.exportProfileToExportProfileDto(profile);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response profilesProfileIdPut(Long profileId, UpdateProfileDto updateProfileDto) {
        if (updateProfileDto.getSpace() == null) {
            this.permissionService.checkCurrentUserHasConfluenceAdminPermission();
        } else {
            this.permissionService.checkCurrentUserHasSpaceAdminPermission(updateProfileDto.getSpace());
        }
        DtoValidatorHelper.validate(updateProfileDto);
        if (!Objects.equals(profileId, updateProfileDto.getId())) {
            throw new BadRequestException("cex.profile.error.invalid", new Map.Entry[0]);
        }
        ExportProfile profile = (ExportProfile)this.profileRepository.getById(profileId.longValue());
        if (profile == null) {
            throw new NotFoundException("cex.profile.error.notFound", new Map.Entry[]{Map.entry("id", profileId)});
        }
        ExportProfileMapper.INSTANCE.updateExportProfileFromDto(updateProfileDto, profile);
        ExportProfileDto response = ExportProfileMapper.INSTANCE.exportProfileToExportProfileDto(this.exportProfileService.saveProfile(profile));
        return Response.ok((Object)response).build();
    }

    @Override
    public Response profilesSpaceSpaceKeyGet(String spaceKey) {
        this.permissionService.checkCurrentUserHasSpaceViewPermission(spaceKey);
        List profiles = this.profileRepository.findAllInSpace(spaceKey);
        List response = ExportProfileMapper.INSTANCE.exportProfileListToExportProfileDtoList(profiles);
        return Response.ok((Object)response).build();
    }
}

