/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.newcontrollers;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.service.PageService;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import hu.metainf.plugin.confluence.contentexporter.ContentExporterException;
import hu.metainf.plugin.confluence.contentexporter.controllers.ContentExporterFactory;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.dao.ExportParametersRepository;
import hu.metainf.plugin.confluence.contentexporter.exception.BadRequestException;
import hu.metainf.plugin.confluence.contentexporter.exception.CexException;
import hu.metainf.plugin.confluence.contentexporter.exception.NotFoundException;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentExporter;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.exporter.io.HttpUtil;
import hu.metainf.plugin.confluence.contentexporter.mapper.ConfluencePageTreeMapper;
import hu.metainf.plugin.confluence.contentexporter.mapper.ExportParametersMapper;
import hu.metainf.plugin.confluence.contentexporter.mapper.ProgressDataMapper;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePageTreeDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportDetailsDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParameters;
import hu.metainf.plugin.confluence.contentexporter.model.ExportParametersDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportProgressDto;
import hu.metainf.plugin.confluence.contentexporter.model.ExportType;
import hu.metainf.plugin.confluence.contentexporter.model.ExportTypeDto;
import hu.metainf.plugin.confluence.contentexporter.model.OutputFormat;
import hu.metainf.plugin.confluence.contentexporter.model.ProgressDataDto;
import hu.metainf.plugin.confluence.contentexporter.server.api.ExportApi;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import hu.metainf.plugin.confluence.contentexporter.service.ExportExecutorService;
import hu.metainf.plugin.confluence.contentexporter.service.ExportFutureTask;
import hu.metainf.plugin.confluence.contentexporter.service.PermissionService;
import hu.metainf.plugin.confluence.contentexporter.util.DtoValidatorHelper;
import hu.metainf.plugin.confluence.contentexporter.util.ErrorExtractor;
import hu.metainf.plugin.confluence.contentexporter.util.ResponseHandler;
import hu.metainf.plugin.confluence.contentexporter.util.ValidatorHelper;
import hu.metainf.plugin.util.DataCenterHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/export")
public class ExportController
implements ExportApi {
    private static final Logger logger = LoggerFactory.getLogger(ExportController.class);
    private final ExportParametersRepository exportParametersRepository;
    private final ExportExecutorService exportExecutorService;
    private final PageService pageService;
    private final ConfigurationRepository configurationRepository;
    private final DataCenterHelper dataCenterHelper;
    private final ConfluenceContentService confluenceContentService;
    private final ContentExporterFactory contentExporterFactory;
    private final Renderer renderer;
    private final PermissionService permissionService;
    private final AccessModeService accessModeService;
    private static final String HASH_PARAMETER_NAME = "hash";

    @Inject
    public ExportController(ExportParametersRepository exportParametersRepository, ExportExecutorService exportExecutorService, PageService pageService, ConfigurationRepository configurationRepository, DataCenterHelper dataCenterHelper, ConfluenceContentService confluenceContentService, ContentExporterFactory contentExporterFactory, Renderer renderer, PermissionService permissionService, AccessModeService accessModeService) {
        this.exportParametersRepository = exportParametersRepository;
        this.exportExecutorService = exportExecutorService;
        this.pageService = pageService;
        this.configurationRepository = configurationRepository;
        this.dataCenterHelper = dataCenterHelper;
        this.confluenceContentService = confluenceContentService;
        this.contentExporterFactory = contentExporterFactory;
        this.renderer = renderer;
        this.permissionService = permissionService;
        this.accessModeService = accessModeService;
    }

    @Override
    public Response exportDownloadGet(String hash) {
        this.permissionService.checkLicense();
        ValidatorHelper.validateNotBlank((String)hash, (String)HASH_PARAMETER_NAME);
        return this.getFileDownloadResponse(hash);
    }

    @Override
    public Response exportPageIdExportParametersGet(Long pageId) {
        this.checkIfPageIsNull(pageId);
        this.permissionService.checkCurrentUserHasSpaceExportOrPageViewPermission(pageId);
        ExportParameters exportParameters = this.exportParametersRepository.loadLastExportParameters(pageId);
        ExportParametersDto response = ExportParametersMapper.INSTANCE.exportParametersToExportParametersDto(exportParameters);
        return Response.ok((Object)response).build();
    }

    @Override
    public Response exportPageIdGet(Long pageId, String hash) {
        this.checkIfPageIsNull(pageId);
        this.permissionService.checkLicense();
        this.permissionService.checkCurrentUserHasSpaceExportPermission(pageId);
        ValidatorHelper.validateNotBlank((String)hash, (String)HASH_PARAMETER_NAME);
        try {
            ExportFutureTask future = this.exportExecutorService.getExportFuture(hash);
            if (future == null) {
                throw new NotFoundException("cex.export.job.error.notFound", new Map.Entry[]{Map.entry(HASH_PARAMETER_NAME, hash)});
            }
            ContentExporter contentExporter = future.getContentExporter();
            contentExporter.extract();
            OperationResult operationResult = contentExporter.getStatus();
            if (operationResult.isSuccess()) {
                this.exportExecutorService.execute(hash);
            } else {
                ErrorExtractor.throwExceptionIfOperationResultHasErrors(operationResult, new CexException("cex.export.error", new Map.Entry[0]));
            }
        }
        catch (ContentExporterException e) {
            throw new CexException("cex.export.error", (Throwable)e);
        }
        return ResponseHandler.NO_CONTENT_RESPONSE;
    }

    @Override
    public Response exportPageIdInitPost(Long pageId, ExportParametersDto exportParametersDto) {
        this.checkIfPageIsNull(pageId);
        this.permissionService.checkLicense();
        this.permissionService.checkCurrentUserHasSpaceExportPermission(pageId);
        DtoValidatorHelper.validate(exportParametersDto);
        if (!Objects.equals(pageId, exportParametersDto.getRootContentId())) {
            throw new BadRequestException("cex.export.error.invalid", new Map.Entry[0]);
        }
        if (ExportTypeDto.TREE.equals((Object)exportParametersDto.getExportType()) && (exportParametersDto.getSelectedContentIdList() == null || exportParametersDto.getSelectedContentIdList().isEmpty())) {
            throw new BadRequestException("cex.export.error.invalid", new Map.Entry[0]);
        }
        ExportParameters exportParameters = new ExportParameters();
        ExportParametersMapper.INSTANCE.updateExportParametersFromDto(exportParametersDto, exportParameters);
        this.setFinalOutputFormat(exportParameters);
        ExportType exportType = exportParameters.getExportType();
        switch (exportType) {
            case PAGE: {
                exportParameters.getSelectedContentIdList().clear();
                exportParameters.getSelectedContentIdList().add(pageId);
                break;
            }
            case ALL_CHILD: {
                exportParameters.getSelectedContentIdList().clear();
                Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
                ConfluencePage rootPage = this.confluenceContentService.getPageTree(page);
                this.getChildrenPages(rootPage, exportParameters.getSelectedContentIdList());
            }
        }
        ContentExporter contentExporter = this.contentExporterFactory.createContentExporter(exportParameters, this.renderer);
        this.exportExecutorService.queueExport(contentExporter, AuthenticatedUserThreadLocal.get());
        this.saveExportParameters(exportParameters);
        ExportDetailsDto result = new ExportDetailsDto();
        result.setHash(contentExporter.getExportId());
        return Response.ok((Object)result).build();
    }

    @Override
    public Response exportPageIdPageTreeGet(Long pageId) {
        Page page = this.checkIfPageIsNull(pageId);
        this.permissionService.checkCurrentUserHasSpaceExportPermission(pageId);
        ConfluencePageTreeDto result = ConfluencePageTreeMapper.INSTANCE.confluencePageToConfluencePageTreeDto(this.confluenceContentService.getPageTree(page));
        return Response.ok((Object)result).build();
    }

    @Override
    public Response exportPollGet(String hash) {
        ExportProgressDto result;
        block7: {
            this.permissionService.checkLicense();
            ValidatorHelper.validateNotBlank((String)hash, (String)HASH_PARAMETER_NAME);
            logger.debug("Calling poll for: {}", (Object)hash);
            ExportFutureTask future = this.exportExecutorService.getExportFuture(hash);
            if (future == null) {
                throw new NotFoundException("cex.export.job.error.notFound", new Map.Entry[]{Map.entry(HASH_PARAMETER_NAME, hash)});
            }
            ContentExporter exporter = future.getContentExporter();
            this.permissionService.validateExportUser(exporter.getExportUserInfo());
            result = new ExportProgressDto();
            boolean done = future.isDone();
            result.setDone(Boolean.valueOf(done));
            if (done) {
                try {
                    OperationResult operationResult = future.getResult();
                    boolean success = operationResult.isSuccess();
                    if (!success) {
                        if (operationResult.getErrors().hasAnyErrorMessages()) {
                            String errorMessage = operationResult.getErrors().getGlobalErrorMessage();
                            String stacktrace = operationResult.getErrors().getGlobalErrorDetails();
                            throw new CexException("cex.export.error", new Map.Entry[]{Map.entry("errorMessage", errorMessage), Map.entry("reason", this.replaceLineBreak(stacktrace))});
                        }
                        throw new CexException("cex.export.poll.error", new Map.Entry[0]);
                    }
                    break block7;
                }
                catch (CexException e) {
                    throw e;
                }
                catch (Exception e) {
                    logger.error("Exception during poll", (Throwable)e);
                    throw new CexException("cex.export.poll.error", new Map.Entry[0]);
                }
            }
            ProgressDataDto progressData = ProgressDataMapper.INSTANCE.progressDataToProgressDataDto(future.getContentExporter().getProgress().getData());
            result.setProgressData(progressData);
        }
        return Response.ok((Object)result).build();
    }

    private void setFinalOutputFormat(ExportParameters exportParameters) {
        if (OutputFormat.PDF.equals((Object)exportParameters.getOutputFormat()) && (this.dataCenterHelper.isDataCenter() || !this.configurationRepository.load().isPageBreakOptionEnabled() || exportParameters.getFormatting().isSeparatePage())) {
            exportParameters.setOutputFormat(OutputFormat.PDF_MERGE);
            logger.debug("PDF MERGE output format has been set.");
        }
    }

    private Response getFileDownloadResponse(String hash) {
        ValidatorHelper.validateNotBlank((String)hash, (String)HASH_PARAMETER_NAME);
        logger.debug("Start download for hash: {}", (Object)hash);
        ExportFutureTask future = this.exportExecutorService.getExportFuture(hash);
        if (future == null) {
            logger.debug("Job not found for hash: {}", (Object)hash);
            throw new NotFoundException("cex.export.job.error.notFound", new Map.Entry[]{Map.entry(HASH_PARAMETER_NAME, hash)});
        }
        if (!future.isDone()) {
            logger.debug("Job is not ready for hash: {}", (Object)hash);
            throw new BadRequestException("cex.export.job.error.notReady", new Map.Entry[]{Map.entry(HASH_PARAMETER_NAME, hash)});
        }
        try {
            ContentExporter exporter = (ContentExporter)future.get();
            this.permissionService.validateExportUser(exporter.getExportUserInfo());
            if (exporter.getStatus().getErrors().hasAnyErrorMessages()) {
                String errorMessage = exporter.getStatus().getErrors().getGlobalErrorMessage();
                String stacktrace = exporter.getStatus().getErrors().getGlobalErrorDetails();
                throw new CexException("cex.export.error", new Map.Entry[]{Map.entry("errorMessage", errorMessage), Map.entry("reason", this.replaceLineBreak(stacktrace))});
            }
            File outputFile = (File)exporter.getStatus().getData();
            if (!outputFile.exists()) {
                logger.debug("Exported file not found: {}", (Object)outputFile);
                throw new CexException("cex.export.file.error.notFound", new Map.Entry[]{Map.entry("filePath", outputFile.getAbsolutePath())});
            }
            Response.ResponseBuilder response = this.getFileDownloadResponseBuilderWithHeaders(exporter.getOutputFilename(), outputFile, hash).type("application/octet-stream");
            this.cleanup(exporter);
            return response.build();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            logger.error("Job failed for hash: {}", (Object)hash, (Object)cause);
            throw new CexException("cex.export.file.error", new Map.Entry[0]);
        }
        catch (CexException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Job failed for hash: {}", (Object)hash, (Object)e);
            throw new CexException("cex.export.file.error", new Map.Entry[0]);
        }
    }

    private Response.ResponseBuilder getFileDownloadResponseBuilderWithHeaders(String filename, File file, String hash) throws IOException {
        filename = HttpUtil.encodeURIComponent((String)filename);
        byte[] fileData = Files.readAllBytes(file.toPath());
        return Response.ok((Object)fileData).header("Content-Disposition", (Object)("attachment; filename*=UTF-8''" + filename + ";")).header("File-name", (Object)filename).header("Content-Length", (Object)fileData.length).header("Set-Cookie", (Object)("content-export-" + hash + "=success; path=/")).header("Cache-Control", (Object)"private, must-revalidate, max-age=5").header("Pragma", (Object)"").header("Expires", (Object)System.currentTimeMillis());
    }

    private void getChildrenPages(ConfluencePage rootPage, List<Long> selectedContentIdList) {
        selectedContentIdList.add(rootPage.getId());
        for (ConfluencePage child : rootPage.getChildren()) {
            this.getChildrenPages(child, selectedContentIdList);
        }
    }

    private void saveExportParameters(ExportParameters exportParameters) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && exportParameters != null && exportParameters.getRootContentId() != null && !this.accessModeService.isReadOnlyAccessModeEnabled()) {
            this.exportParametersRepository.save(exportParameters);
        }
    }

    private void cleanup(ContentExporter exporter) {
        if (!ConfluenceSystemProperties.isDisableCaches()) {
            exporter.cleanup();
        }
    }

    private String replaceLineBreak(String stacktrace) {
        if (stacktrace == null) {
            return "";
        }
        return stacktrace.replace("\r", "\n").replace("\t", "\n").replace("\n\n\n", "\n").replace("\n\n", "\n");
    }

    private Page checkIfPageIsNull(Long pageId) {
        Page page = this.pageService.getIdPageLocator(pageId.longValue()).getPage();
        if (page == null) {
            throw new NotFoundException("cex.export.error.pageNotFound", new Map.Entry[]{Map.entry("id", pageId)});
        }
        return page;
    }
}

