/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.renderer.RenderContext;
import hu.metainf.plugin.confluence.contentexporter.exporter.ContentFetcher;
import hu.metainf.plugin.confluence.contentexporter.exporter.Fetch;
import hu.metainf.plugin.confluence.contentexporter.exporter.standalone.StandalonePermissionUtil;
import hu.metainf.plugin.confluence.contentexporter.model.ConfluencePage;
import hu.metainf.plugin.confluence.contentexporter.model.Statistics;
import hu.metainf.plugin.confluence.contentexporter.service.ConfluenceContentService;
import hu.metainf.plugin.confluence.contentexporter.service.PageTreeFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneContentFetcher
implements ContentFetcher {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneContentFetcher.class);
    private static final String UNKNOWN_USER_DISPLAYNAME = "Anonymous";
    private static final String CURRENT_CONTENT_STATUS = "current";
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final ConfluenceContentService confluenceContentService;
    private final PageTreeFilter pageTreeFilter = new PageTreeFilter();
    private Renderer renderer;
    private ConfluenceUser user;
    private String baseUrl;
    private String contextPath;

    public StandaloneContentFetcher(PageManager pageManager, PermissionManager permissionManager, ConfluenceContentService confluenceContentService, Renderer renderer, String baseUrl, String contextPath, ConfluenceUser user) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.confluenceContentService = confluenceContentService;
        this.baseUrl = baseUrl;
        this.contextPath = contextPath;
        this.renderer = renderer;
        this.user = user;
    }

    public ConfluencePage getPage(long pageId, EnumSet<Fetch> fetchOptions, Statistics statistics) {
        Page page = this.pageManager.getPage(pageId);
        if (page == null || !CURRENT_CONTENT_STATUS.equals(page.getContentStatus()) && !CURRENT_CONTENT_STATUS.toUpperCase().equals(page.getContentStatus())) {
            logger.debug("Page not found: {}", (Object)pageId);
            return null;
        }
        if (!StandalonePermissionUtil.canUserAccessToPage(this.user, (AbstractPage)page, this.permissionManager)) {
            logger.debug("No view access for page: {} user: {}", (Object)pageId, (Object)this.user);
            return null;
        }
        logger.debug("Page URL: {}", (Object)page.getUrlPath());
        logger.debug("Page title: {}", (Object)page.getTitle());
        logger.debug("Page display title: {}", (Object)page.getDisplayTitle());
        ConfluencePage result = new ConfluencePage(pageId, page.getTitle(), this.contextPath + page.getUrlPath());
        result.setParentHierarchy(this.getParentPages(page));
        if (!result.getParentHierarchy().isEmpty()) {
            result.setParentId((Long)result.getParentHierarchy().get(result.getParentHierarchy().size() - 1));
        }
        if (fetchOptions.contains(Fetch.BODY_IN_EXPORT_VIEW)) {
            PageContext context = page.toPageContext();
            context.setBaseUrl(this.baseUrl);
            context.setSiteRoot(this.contextPath);
            context.setOutputType(ConversionContextOutputType.PDF.value());
            logger.debug("renderer: {}", (Object)this.renderer);
            logger.debug("page: {}", (Object)page);
            logger.debug("context: {}", (Object)context);
            String body = this.renderer.render((ContentEntityObject)page, (ConversionContext)new DefaultConversionContext((RenderContext)context));
            result.setBody(body);
        }
        if (fetchOptions.contains(Fetch.VERSION_INFO)) {
            result.setTitle(page.getTitle());
            result.setVersion(page.getVersion());
            ConfluenceUser creator = page.getCreator();
            result.setCreatorFullName(creator != null ? creator.getFullName() : UNKNOWN_USER_DISPLAYNAME);
            result.setCreatorUsername(creator != null ? creator.getName() : UNKNOWN_USER_DISPLAYNAME);
            result.setCreatedDate(page.getCreationDate());
            ConfluenceUser lastModifier = page.getLastModifier();
            result.setLastModifierFullName(lastModifier != null ? lastModifier.getFullName() : UNKNOWN_USER_DISPLAYNAME);
            result.setLastModifierUsername(lastModifier != null ? lastModifier.getName() : UNKNOWN_USER_DISPLAYNAME);
            result.setLastModifiedDate(page.getLastModificationDate());
        }
        return result;
    }

    public List<ConfluencePage> getFilteredPageTree(long rootPageId, List<Long> ids) {
        Page page = this.pageManager.getPage(rootPageId);
        ConfluencePage pageTree = this.confluenceContentService.getPageTree(page);
        return this.pageTreeFilter.filter(Collections.singletonList(pageTree), ids);
    }

    private List<Long> getParentPages(Page page) {
        ArrayList<Long> result = new ArrayList<Long>();
        List parents = page.getAncestors();
        for (Page p : parents) {
            result.add(p.getId());
        }
        return result;
    }
}

