/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.service;

import hu.metainf.plugin.confluence.contentexporter.dao.FontRepository;
import hu.metainf.plugin.confluence.contentexporter.exporter.OperationResult;
import hu.metainf.plugin.confluence.contentexporter.model.Font;
import hu.metainf.plugin.confluence.contentexporter.model.FontFile;
import hu.metainf.plugin.confluence.contentexporter.resource.AppConsts;
import hu.metainf.plugin.confluence.contentexporter.service.FontService;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class FontServiceImpl
implements FontService {
    public static final String INVALID_EXTENSION = "hu.metainf.plugin.confluence.contentexporter.invalid-extension";
    private final FontRepository fontRepository;

    public FontServiceImpl(FontRepository fontRepository) {
        this.fontRepository = fontRepository;
    }

    @Override
    public OperationResult save(Font newFont) {
        OperationResult result = new OperationResult();
        String fontName = newFont.getName();
        if (StringUtils.isEmpty((CharSequence)fontName)) {
            result.addError("name", "hu.metainf.plugin.confluence.contentexporter.mandatory", Collections.singletonList("name"));
        }
        if (newFont.getFiles().isEmpty()) {
            result.addError("font", "hu.metainf.plugin.confluence.contentexporter.least-one-file");
        } else {
            for (FontFile file : newFont.getFiles()) {
                String fileName = file.getFileName();
                String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (this.isValidExtension(extension)) continue;
                List<Object> strings = Arrays.asList(extension, AppConsts.VALID_FONT_EXTENSIONS.toString());
                result.addError("font", INVALID_EXTENSION, strings);
            }
        }
        if (result.isSuccess()) {
            StringBuilder fileNames = new StringBuilder();
            Iterator fileIterator = newFont.getFiles().iterator();
            while (fileIterator.hasNext()) {
                FontFile file = (FontFile)fileIterator.next();
                file.setHash(DigestUtils.sha256Hex((byte[])file.getFontData()));
                fileNames.append(file.getFileName());
                if (!fileIterator.hasNext()) continue;
                fileNames.append(", ");
            }
            newFont.setFileNames(fileNames.toString());
            Font savedFont = (Font)this.fontRepository.save((Object)newFont);
            result.setData((Object)savedFont);
        }
        return result;
    }

    private boolean isValidExtension(String extension) {
        for (String validExtension : AppConsts.VALID_FONT_EXTENSIONS) {
            if (!validExtension.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void delete(Long id) {
        this.fontRepository.delete(id);
    }

    @Override
    public List<Font> loadAll() {
        return this.fontRepository.findAll();
    }
}

