/*
 * Decompiled with CFR 0.152.
 */
package hu.metainf.plugin.confluence.contentexporter.exporter.standalone;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import hu.metainf.plugin.confluence.contentexporter.dao.ConfigurationRepository;
import hu.metainf.plugin.confluence.contentexporter.model.Configuration;
import hu.metainf.plugin.confluence.contentexporter.model.ExportPermissions;

public class StandalonePermissionUtil {
    private StandalonePermissionUtil() {
    }

    public static boolean hasUserPermissionBasedOnConfiguration(ConfluenceUser user, AbstractPage page, SpacePermissionManager spacePermissionManager, ConfigurationRepository configurationRepository) {
        Configuration configuration = configurationRepository.load();
        boolean result = configuration.getExportPermission().equals(ExportPermissions.CONFLUENCE_PERMISSION.toString()) ? StandalonePermissionUtil.hasUserSpaceExportPermission(user, page, spacePermissionManager) : StandalonePermissionUtil.hasUserSpaceViewPermission(user, page.getSpace(), spacePermissionManager);
        return result;
    }

    public static boolean hasUserSpaceExportPermission(ConfluenceUser user, AbstractPage page, SpacePermissionManager spacePermissionManager) {
        return spacePermissionManager.hasPermission("EXPORTSPACE", page.getSpace(), user);
    }

    public static boolean hasUserSpaceViewPermission(ConfluenceUser user, Space space, SpacePermissionManager spacePermissionManager) {
        return spacePermissionManager.hasPermission("VIEWSPACE", space, user);
    }

    public static boolean canUserAccessToPage(ConfluenceUser user, AbstractPage page, PermissionManager permissionManager) {
        return page instanceof Page && permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }

    public static boolean hasUserSpaceAdminPermission(ConfluenceUser user, Space space, SpacePermissionManager spacePermissionManager) {
        return spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, user);
    }
}

